/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.boot;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="tracer")
public class TraceProperties {
    private int sessionIdLength = 32;
    private int invocationIdLength = 32;
    private Map<TraceFilterConfiguration.Channel, Pattern> filter = new HashMap<TraceFilterConfiguration.Channel, Pattern>();
    private Map<String, Profile> profile = new HashMap<String, Profile>();
    private TraceFilterConfiguration delegate = new TraceFilterConfiguration(){

        @Override
        public boolean shouldProcessParam(String paramName, TraceFilterConfiguration.Channel channel) {
            return true;
        }

        @Override
        public Map<String, String> filterDeniedParams(Map<String, String> unfiltered, TraceFilterConfiguration.Channel channel) {
            return unfiltered;
        }

        @Override
        public boolean shouldProcessContext(TraceFilterConfiguration.Channel channel) {
            return true;
        }

        @Override
        public boolean shouldGenerateInvocationId() {
            return TraceProperties.this.invocationIdLength > 0;
        }

        @Override
        public int generatedInvocationIdLength() {
            return TraceProperties.this.invocationIdLength;
        }

        @Override
        public boolean shouldGenerateSessionId() {
            return TraceProperties.this.sessionIdLength > 0;
        }

        @Override
        public int generatedSessionIdLength() {
            return TraceProperties.this.sessionIdLength;
        }
    };

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(int sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public int getInvocationIdLength() {
        return this.invocationIdLength;
    }

    public void setInvocationIdLength(int invocationIdLength) {
        this.invocationIdLength = invocationIdLength;
    }

    public Map<TraceFilterConfiguration.Channel, Pattern> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<TraceFilterConfiguration.Channel, Pattern> filter) {
        this.filter = filter;
    }

    public Map<String, Profile> getProfile() {
        return this.profile;
    }

    public void setProfile(Map<String, Profile> profile) {
        this.profile = profile;
    }

    public TraceFilterConfiguration getAsFilterConfiguration() {
        return this.delegate;
    }

    public static class Profile {
        private Map<TraceFilterConfiguration.Channel, Pattern> filter;

        public Map<TraceFilterConfiguration.Channel, Pattern> getFilter() {
            return this.filter;
        }

        public void setFilter(Map<TraceFilterConfiguration.Channel, Pattern> filter) {
            this.filter = filter;
        }
    }
}

