/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.base.spring;

import com.alibaba.fastjson.JSON;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class Controller {
    public static String write(ErrorCode respCode) {
        return Controller.write(respCode, null);
    }

    public static String write(ErrorCode respCode, Object data) {
        return Controller.write(respCode.getErrcode(), respCode.getErrmsg(), data);
    }

    public static String write(ErrorCode respCode, String message) {
        return Controller.write(respCode.getErrcode(), StringUtils.isEmpty(message) ? respCode.getErrmsg() : message);
    }

    public static String write(Object data) {
        return Controller.write(ErrorCode.EM_SUCCESS, data);
    }

    public static String write(String errcode) {
        return Controller.write(ErrorCode.of(errcode), null);
    }

    public static String write(String errcode, String errmsg) {
        return Controller.write(errcode, errmsg, null);
    }

    public static String write(String errcode, String errmsg, Object data) {
        ErrorCode resultCode = ErrorCode.of(errcode);
        if (ObjectUtils.isNotEmpty(new Object[]{resultCode})) {
            errmsg = StringUtils.isEmpty(errmsg) ? resultCode.getErrmsg() : errmsg;
            return JSON.toJSON((Object)new Message(resultCode.getErrcode(), errmsg, data)).toString();
        }
        return JSON.toJSON((Object)new Message(ErrorCode.EM_FAILURE.getErrcode(), ErrorCode.EM_FAILURE.errmsg)).toString();
    }
}

