/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.plugin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.aoju.bus.pager.PageException;
import org.aoju.bus.pager.cache.Cache;
import org.aoju.bus.pager.cache.CacheFactory;
import org.aoju.bus.pager.dialect.Dialect;
import org.aoju.bus.pager.plugin.CountExecutor;
import org.aoju.bus.pager.plugin.CountMappedStatement;
import org.aoju.bus.pager.plugin.PageFromObject;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageInterceptor
implements Interceptor {
    protected Cache<String, MappedStatement> msCountMap = null;
    private volatile Dialect dialect;
    private String countSuffix = "_COUNT";
    private String default_dialect_class = "org.aoju.bus.pager.PageContext";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        try {
            List resultList;
            CacheKey cacheKey;
            BoundSql boundSql;
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            Executor executor = (Executor)invocation.getTarget();
            if (args.length == 4) {
                boundSql = ms.getBoundSql(parameter);
                cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
            } else {
                cacheKey = (CacheKey)args[4];
                boundSql = (BoundSql)args[5];
            }
            this.checkDialectExists();
            if (!this.dialect.skip(ms, parameter, rowBounds)) {
                Long count;
                if (this.dialect.beforeCount(ms, parameter, rowBounds) && !this.dialect.afterCount(count = this.count(executor, ms, parameter, rowBounds, resultHandler, boundSql), parameter, rowBounds)) {
                    Object object = this.dialect.afterPage(new ArrayList(), parameter, rowBounds);
                    return object;
                }
                resultList = CountExecutor.pageQuery(this.dialect, executor, ms, parameter, rowBounds, resultHandler, boundSql, cacheKey);
            } else {
                resultList = executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
            }
            Object object = this.dialect.afterPage(resultList, parameter, rowBounds);
            return object;
        }
        finally {
            this.dialect.afterAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDialectExists() {
        if (this.dialect == null) {
            String string = this.default_dialect_class;
            synchronized (string) {
                if (this.dialect == null) {
                    this.setProperties(new Properties());
                }
            }
        }
    }

    private Long count(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Long count;
        String countMsId = ms.getId() + this.countSuffix;
        MappedStatement countMs = CountExecutor.getExistedMappedStatement(ms.getConfiguration(), countMsId);
        if (countMs != null) {
            count = CountExecutor.executeManualCount(executor, countMs, parameter, boundSql, resultHandler);
        } else {
            countMs = this.msCountMap.get(countMsId);
            if (countMs == null) {
                countMs = CountMappedStatement.newCountMappedStatement(ms, countMsId);
                this.msCountMap.put(countMsId, countMs);
            }
            count = CountExecutor.executeAutoCount(this.dialect, executor, countMs, parameter, boundSql, rowBounds, resultHandler);
        }
        return count;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.msCountMap = CacheFactory.createCache(properties.getProperty("msCountCache"), "ms", properties);
        String dialectClass = properties.getProperty("dialect");
        if (PageFromObject.isEmpty(dialectClass)) {
            dialectClass = this.default_dialect_class;
        }
        try {
            Class<?> aClass = Class.forName(dialectClass);
            this.dialect = (Dialect)aClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException(e);
        }
        this.dialect.setProperties(properties);
        String countSuffix = properties.getProperty("countSuffix");
        if (PageFromObject.isNotEmpty(countSuffix)) {
            this.countSuffix = countSuffix;
        }
    }
}

