/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public final class PropertiesUtils {
    private static Map<String, String> ctxPropertiesMap = new HashMap<String, String>();

    public static Map<String, String> getProperties() {
        return ctxPropertiesMap;
    }

    public static String getString(String key) {
        try {
            return ctxPropertiesMap.get(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getString(String key, String defaultValue) {
        try {
            String value = ctxPropertiesMap.get(key);
            if (ObjectUtils.isEmpty(value)) {
                return defaultValue;
            }
            return value;
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public static int getInt(String key) {
        return Integer.parseInt(ctxPropertiesMap.get(key));
    }

    public static int getInt(String key, int defaultValue) {
        String value = ctxPropertiesMap.get(key);
        if (StringUtils.isBlank(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = ctxPropertiesMap.get(key);
        if (StringUtils.isBlank(value)) {
            return defaultValue;
        }
        return new Boolean(value);
    }

    public static String getString(String className, String path, String propertyKey) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InstrumentException(e);
        }
        InputStream in = clazz.getResourceAsStream(path);
        Properties prop = new Properties();
        try {
            prop.load(in);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return prop.getProperty(propertyKey);
    }
}

