/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.cron.pattern.parser.ValueParser;

public class SimpleValueParser
implements ValueParser {
    protected int min;
    protected int max;

    public SimpleValueParser(int min, int max) {
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    @Override
    public int parse(String value) throws CommonException {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new CommonException("Invalid integer value: [{}]", value);
        }
        if (i < this.min || i > this.max) {
            throw new CommonException("Value [{}] out of range: [{} , {}]", i, this.min, this.max);
        }
        return i;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

