/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.lock.jdk;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.limiter.support.lock.Lock;
import org.aoju.bus.logger.Logger;

public class JdkLock
extends Lock {
    private String lockName;
    private ConcurrentHashMap<Object, java.util.concurrent.locks.Lock> locks;

    public JdkLock(String lockName, int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.lockName = lockName;
        this.locks = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public JdkLock(String lockName) {
        this.lockName = lockName;
        this.locks = new ConcurrentHashMap();
    }

    @Override
    public boolean lock(Object key) {
        ReentrantLock lock = new ReentrantLock();
        java.util.concurrent.locks.Lock oldLock = this.locks.putIfAbsent(key, lock);
        if (oldLock != null) {
            boolean ret = oldLock.tryLock();
            if (ret) {
                Logger.info("acquire lock on  {}  success", key);
            } else {
                Logger.info("acquire lock on {} fail", key);
            }
            return ret;
        }
        boolean ret = lock.tryLock();
        if (ret) {
            Logger.info("acquire lock on  {}  success", key);
        } else {
            Logger.info("acquire lock on {} fail", key);
        }
        return ret;
    }

    @Override
    public void unlock(Object key) {
        java.util.concurrent.locks.Lock lock = this.locks.remove(key);
        if (lock == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u8be5\u9501\uff01");
        }
        lock.unlock();
    }

    @Override
    public String getLimiterName() {
        return this.lockName;
    }
}

