/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.thread;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.aoju.bus.core.lang.exception.CommonException;

public class SyncFinisher {
    private CountDownLatch countDownLatch;
    private Set<Worker> workers = new LinkedHashSet<Worker>();

    public synchronized void addWorker(Worker worker) {
        this.workers.add(worker);
    }

    public void start() {
        this.countDownLatch = new CountDownLatch(this.workers.size());
        for (Worker worker : this.workers) {
            worker.start();
        }
    }

    public void await() throws InterruptedException {
        if (this.countDownLatch == null) {
            throw new CommonException("Please call start() method first!");
        }
        this.countDownLatch.await();
    }

    public void clearWorker() {
        this.workers.clear();
    }

    public long count() {
        return this.countDownLatch.getCount();
    }

    public abstract class Worker
    extends Thread {
        @Override
        public void run() {
            try {
                this.work();
            }
            finally {
                SyncFinisher.this.countDownLatch.countDown();
            }
        }

        public abstract void work();
    }
}

