/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.File;
import java.io.IOException;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.consts.MediaType;
import org.aoju.bus.core.io.BufferedSink;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.io.Source;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.http.internal.Internal;

public abstract class RequestBody {
    public static RequestBody create(MediaType contentType, String content) {
        java.nio.charset.Charset charset = Charset.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = Charset.UTF_8;
            contentType = MediaType.get(contentType + "; charset=utf-8");
        }
        byte[] bytes = content.getBytes(charset);
        return RequestBody.create(contentType, bytes);
    }

    public static RequestBody create(final MediaType contentType, final ByteString content) {
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() throws IOException {
                return content.size();
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content);
            }
        };
    }

    public static RequestBody create(MediaType contentType, byte[] content) {
        return RequestBody.create(contentType, content, 0, content.length);
    }

    public static RequestBody create(final MediaType contentType, final byte[] content, final int offset, final int byteCount) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        Internal.checkOffsetAndCount(content.length, offset, byteCount);
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                return byteCount;
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content, offset, byteCount);
            }
        };
    }

    public static RequestBody create(final MediaType contentType, final File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                return file.length();
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = IoUtils.source(file);
                    sink.writeAll(source);
                }
                finally {
                    Internal.closeQuietly(source);
                }
            }
        };
    }

    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;
}

