/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.socket;

import java.util.Arrays;
import java.util.Set;
import org.aoju.bus.socket.netty.annotation.WebSocket;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathSocketScanner
extends ClassPathBeanDefinitionScanner {
    public ClassPathSocketScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public void registerFilters() {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WebSocket.class));
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> !metadataReader.getAnnotationMetadata().hasAnnotation("org.net.websocket.annotation.WebSocket"));
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No WebSocket handler was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return super.isCandidateComponent(beanDefinition);
    }
}

