/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import org.aoju.bus.core.utils.CharUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TextUtils;

public class UnicodeUtils {
    public static String toString(String unicode) {
        if (StringUtils.isBlank(unicode)) {
            return unicode;
        }
        int len = unicode.length();
        TextUtils sb = TextUtils.create(len);
        int i = -1;
        int pos = 0;
        while ((i = StringUtils.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
            sb.append(unicode, pos, i);
            pos = i;
            if (i + 5 < len) {
                char c = '\u0000';
                try {
                    c = (char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16);
                    sb.append(c);
                    pos = i + 6;
                }
                catch (NumberFormatException e) {
                    sb.append(unicode, pos, i + 2);
                    pos = i + 2;
                }
                continue;
            }
            pos = i;
            break;
        }
        if (pos < len) {
            sb.append(unicode, pos, len);
        }
        return sb.toString();
    }

    public static String toUnicode(String str) {
        return UnicodeUtils.toUnicode(str, true);
    }

    public static String toUnicode(String str, boolean isSkipAscii) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        TextUtils unicode = TextUtils.create(str.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (isSkipAscii && CharUtils.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexUtils.toUnicodeHex(c));
        }
        return unicode.toString();
    }
}

