/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.consts.MediaType;
import org.aoju.bus.core.lang.exception.HttpUncheckException;
import org.aoju.bus.core.utils.JsonUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.http.Call;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.RequestBody;
import org.aoju.bus.http.Response;

public class HttpUtils {
    public static HttpClient client = new HttpClient.Builder().writeTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();

    public static String get(String url) throws HttpUncheckException {
        Request request = new Request.Builder().url(url).get().build();
        Call call = client.newCall(request);
        try {
            Response response = call.execute();
            return response.body().string();
        }
        catch (IOException e) {
            throw new HttpUncheckException(e);
        }
    }

    public static void get(String url, Callback callback) {
        Request request = new Request.Builder().url(url).get().build();
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    public static void post(String url, Map<String, Object> map, Callback callback) {
        String data = HttpUtils.getParameterMap(map);
        RequestBody requestBody = RequestBody.create(MediaType.TEXT_HTML_TYPE, data);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    public static String post(String url, Map<String, Object> map) throws HttpUncheckException {
        try {
            String data = HttpUtils.getParameterMap(map);
            RequestBody requestBody = RequestBody.create(MediaType.APPLICATION_FORM_URLENCODED_TYPE, data);
            Request request = new Request.Builder().url(url).post(requestBody).build();
            Call call = client.newCall(request);
            Response response = call.execute();
            return response.body().string();
        }
        catch (IOException e) {
            throw new HttpUncheckException(e);
        }
    }

    public static Object post(String url, Map<String, Object> map, boolean isByte) {
        try {
            String data = HttpUtils.getParameterMap(map);
            RequestBody requestBody = RequestBody.create(MediaType.APPLICATION_FORM_URLENCODED_TYPE, data);
            Request request = new Request.Builder().url(url).post(requestBody).build();
            Call call = client.newCall(request);
            Response response = call.execute();
            if (isByte) {
                return response.body().bytes();
            }
            return response.body().string();
        }
        catch (IOException e) {
            throw new HttpUncheckException(e);
        }
    }

    public static String post(String url, String data, Map<String, Object> hearder, MediaType mediaType) {
        RequestBody requestBody = RequestBody.create(mediaType, data);
        Request.Builder builder = new Request.Builder().url(url);
        if (hearder != null) {
            Set<String> set = hearder.keySet();
            for (String key : set) {
                builder.addHeader(key, String.valueOf(hearder.get(key)));
            }
        }
        Request request = builder.post(requestBody).build();
        Call call = client.newCall(request);
        String result = "";
        try {
            result = call.execute().body().string();
        }
        catch (IOException e) {
            throw new HttpUncheckException(e);
        }
        return result;
    }

    public static String post(String url, Map<String, Object> map, Map<String, Object> hearder, MediaType mediaType) {
        String data = "";
        if (map != null) {
            data = MediaType.APPLICATION_JSON_TYPE.equals(mediaType) ? JsonUtils.toJson(map) : HttpUtils.getParameterMap(map);
        }
        RequestBody requestBody = RequestBody.create(mediaType, data);
        Request.Builder builder = new Request.Builder().url(url);
        if (hearder != null) {
            Set<String> set = hearder.keySet();
            for (String key : set) {
                builder.addHeader(key, String.valueOf(hearder.get(key)));
            }
        }
        Request request = builder.post(requestBody).build();
        Call call = client.newCall(request);
        String result = "";
        try {
            result = call.execute().body().string();
        }
        catch (IOException e) {
            throw new HttpUncheckException(e);
        }
        return result;
    }

    public static void post(String url, Map<String, Object> map, Map<String, Object> hearder, MediaType mediaType, Callback callback) {
        String data = "";
        if (map != null) {
            data = MediaType.APPLICATION_JSON_TYPE.equals(mediaType) ? JsonUtils.toJson(map) : HttpUtils.getParameterMap(map);
        }
        RequestBody requestBody = RequestBody.create(mediaType, data);
        Request.Builder builder = new Request.Builder().url(url);
        if (hearder != null) {
            Set<String> set = hearder.keySet();
            for (String key : set) {
                builder.addHeader(key, String.valueOf(hearder.get(key)));
            }
        }
        Request request = builder.post(requestBody).build();
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    protected static String getParameterMap(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        if (ObjectUtils.isNotEmpty(map)) {
            Set<String> keys = map.keySet();
            for (String key : keys) {
                sb.append(key).append("=").append(map.get(key)).append("&");
            }
        }
        return sb.toString();
    }
}

