/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.aio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.thread.ThreadFactoryBuilder;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.socket.origin.OriginConfig;
import org.aoju.bus.socket.origin.aio.AcceptHandler;
import org.aoju.bus.socket.origin.aio.IoAction;

public class AioServer {
    private static AcceptHandler ACCEPT_HANDLER = new AcceptHandler();
    protected IoAction<ByteBuffer> ioAction;
    protected OriginConfig config;
    private AsynchronousChannelGroup group;
    private AsynchronousServerSocketChannel channel;

    public AioServer(int port) {
        this(new InetSocketAddress(port), new OriginConfig());
    }

    public AioServer(InetSocketAddress address, OriginConfig config) {
        this.config = config;
        this.init(address);
    }

    public AioServer init(InetSocketAddress address) {
        try {
            this.group = AsynchronousChannelGroup.withFixedThreadPool(this.config.getThreadPoolSize(), ThreadFactoryBuilder.create().setNamePrefix("Aoju-socket-").build());
            this.channel = AsynchronousServerSocketChannel.open(this.group).bind(address);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return this;
    }

    public void start(boolean sync) {
        try {
            this.doStart(sync);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
    }

    public <T> AioServer setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.ioAction;
    }

    public AioServer setIoAction(IoAction<ByteBuffer> ioAction) {
        this.ioAction = ioAction;
        return this;
    }

    public AsynchronousServerSocketChannel getChannel() {
        return this.channel;
    }

    public AioServer accept() {
        this.channel.accept(this, ACCEPT_HANDLER);
        return this;
    }

    public boolean isOpen() {
        return null == this.channel ? false : this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IoUtils.close(this.channel);
        if (null != this.group && !this.group.isShutdown()) {
            try {
                this.group.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        AioServer aioServer = this;
        synchronized (aioServer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart(boolean sync) throws IOException {
        this.accept();
        if (sync) {
            AioServer aioServer = this;
            synchronized (aioServer) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

