/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.sensitive.Builder;
import org.aoju.bus.sensitive.Provider;
import org.aoju.bus.sensitive.annotation.JSON;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.spring.SpringContextAware;
import org.aoju.bus.spring.crypto.CryptoProperties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SensitiveStatementHandler
implements Interceptor {
    private static final String MAPPEDSTATEMENT = "delegate.mappedStatement";
    private static final String BOUND_SQL = "delegate.boundSql";

    public Object intercept(Invocation invocation) throws Throwable {
        Sensitive enableSensitive;
        StatementHandler statementHandler = (StatementHandler)SensitiveStatementHandler.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPEDSTATEMENT);
        SqlCommandType commandType = mappedStatement.getSqlCommandType();
        BoundSql boundSql = (BoundSql)metaObject.getValue(BOUND_SQL);
        Object params = boundSql.getParameterObject();
        if (params instanceof Map) {
            return invocation.proceed();
        }
        Sensitive sensitive = enableSensitive = params != null ? params.getClass().getAnnotation(Sensitive.class) : null;
        if (ObjectUtils.isNotEmpty(enableSensitive)) {
            this.handleParameters(mappedStatement.getConfiguration(), boundSql, params, commandType);
        }
        return invocation.proceed();
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private void handleParameters(Configuration configuration, BoundSql boundSql, Object param, SqlCommandType commandType) {
        HashMap<String, Object> newValues = new HashMap<String, Object>(16);
        MetaObject metaObject = configuration.newMetaObject(param);
        for (Field field : param.getClass().getDeclaredFields()) {
            Object value;
            Object newValue = value = metaObject.getValue(field.getName());
            if (value instanceof CharSequence) {
                newValue = this.handlePrivacy(field, newValue);
                if (this.isWriteCommand(commandType) && !Provider.alreadyBeSentisived(newValue)) {
                    newValue = this.handleSensitiveField(field, newValue);
                    newValue = this.handleSensitiveJSONField(field, newValue);
                }
            }
            if (value == null || newValue == null || value.equals(newValue)) continue;
            newValues.put(field.getName(), newValue);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
        }
    }

    private boolean isWriteCommand(SqlCommandType commandType) {
        return SqlCommandType.UPDATE.equals((Object)commandType) || SqlCommandType.INSERT.equals((Object)commandType);
    }

    private Object handlePrivacy(Field field, Object value) {
        Privacy privacy = field.getAnnotation(Privacy.class);
        Object newValue = value;
        if (ObjectUtils.isNotEmpty(privacy) && value != null) {
            CryptoProperties properties = SpringContextAware.getBean(CryptoProperties.class);
            if (ObjectUtils.isEmpty(properties)) {
                throw new InstrumentException("please check the request.crypto.encrypt");
            }
            newValue = CryptoUtils.encrypt(properties.getEncrypt().getType(), properties.getEncrypt().getKey(), value.toString(), Charset.UTF_8);
        }
        return newValue;
    }

    private Object handleSensitiveField(Field field, Object value) {
        org.aoju.bus.sensitive.annotation.Field sensitiveField = field.getAnnotation(org.aoju.bus.sensitive.annotation.Field.class);
        Object newValue = value;
        if (sensitiveField != null && value != null) {
            newValue = Builder.on(value);
        }
        return newValue;
    }

    private Object handleSensitiveJSONField(Field field, Object value) {
        JSON sensitiveJSONField = field.getAnnotation(JSON.class);
        Object newValue = value;
        if (sensitiveJSONField != null && value != null) {
            newValue = this.processJsonField(newValue, sensitiveJSONField);
        }
        return newValue;
    }

    private Object processJsonField(Object newValue, JSON json) {
        try {
            org.aoju.bus.sensitive.annotation.Field[] keys;
            Map<String, Object> map = Provider.parseToObjectMap(newValue.toString());
            for (org.aoju.bus.sensitive.annotation.Field field : keys = json.value()) {
                String key = field.key();
                Object oldData = map.get(key);
                if (oldData == null) continue;
                String newData = (String)Builder.on(oldData);
                map.put(key, newData);
            }
            return Provider.parseMaptoJSONString(map);
        }
        catch (Throwable e) {
            return newValue;
        }
    }

    private static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return SensitiveStatementHandler.realTarget(metaObject.getValue("hi.target"));
        }
        return (T)target;
    }
}

