/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import org.aoju.bus.base.spring.BaseAdvice;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.sensitive.Builder;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.spring.sensitive.SensitiveProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

public class ResponseBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice<Object> {
    @Autowired
    SensitiveProperties properties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Annotation[] annotations = returnType.getDeclaringClass().getAnnotations();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Privacy) && !(annotation instanceof Sensitive)) continue;
                return true;
            }
        }
        return returnType.getMethod().isAnnotationPresent(Privacy.class) || returnType.getMethod().isAnnotationPresent(Sensitive.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter parameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> converterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (!this.properties.isDebug()) {
            try {
                Privacy privacy;
                Sensitive sensitive = parameter.getMethod().getAnnotation(Sensitive.class);
                if (ObjectUtils.isNotNull(sensitive)) {
                    body = Builder.on(body, sensitive);
                }
                if (ObjectUtils.isNotNull(privacy = parameter.getMethod().getAnnotation(Privacy.class)) && StringUtils.isNotEmpty(privacy.value()) && ("ALL".equals(privacy.value()) || "OUT".equals(privacy.value()))) {
                    String encryptKey = this.properties.getDecrypt().getKey();
                    String encryptType = this.properties.getDecrypt().getType();
                    if (!StringUtils.hasText(encryptKey) || !StringUtils.hasText(encryptType)) {
                        throw new NullPointerException("please check the request.sensitive.encrypt");
                    }
                    String content = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(body);
                    content = CryptoUtils.encrypt(this.properties.getDecrypt().getType(), this.properties.getDecrypt().getKey(), content, Charset.UTF_8);
                    return Base64.encode(content);
                }
            }
            catch (Exception e) {
                Logger.error("\u52a0\u5bc6\u6570\u636e\u5f02\u5e38:" + e.getMessage(), new Object[0]);
            }
        }
        return body;
    }
}

