/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.convert.ConverterRegistry;
import org.aoju.bus.core.iterator.ArrayIterator;
import org.aoju.bus.core.iterator.EnumerationIterator;
import org.aoju.bus.core.iterator.IteratorEnumeration;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Matcher;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.FieldUtils;
import org.aoju.bus.core.utils.IterUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TypeUtils;

public class CollUtils {
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (CollUtils.isEmpty(coll1)) {
            list.addAll(coll2);
        } else if (CollUtils.isEmpty(coll2)) {
            list.addAll(coll1);
        } else {
            Map<T, Integer> map1 = CollUtils.countMap(coll1);
            Map<T, Integer> map2 = CollUtils.countMap(coll2);
            HashSet<T> elts = CollUtils.newHashSet(coll2);
            elts.addAll(coll1);
            for (Object t : elts) {
                int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> union = CollUtils.union(coll1, coll2);
        for (Collection<T> coll : otherColls) {
            union = CollUtils.union(union, coll);
        }
        return union;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollUtils.isNotEmpty(coll1) && CollUtils.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollUtils.countMap(coll1);
            Map<T, Integer> map2 = CollUtils.countMap(coll2);
            HashSet elts = CollUtils.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> intersection = CollUtils.intersection(coll1, coll2);
        if (CollUtils.isEmpty(intersection)) {
            return intersection;
        }
        for (Collection<T> coll : otherColls) {
            if (!CollUtils.isEmpty(intersection = CollUtils.intersection(intersection, coll))) continue;
            return intersection;
        }
        return intersection;
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        if (CollUtils.isEmpty(coll1)) {
            return coll2;
        }
        if (CollUtils.isEmpty(coll2)) {
            return coll1;
        }
        ArrayList result = new ArrayList();
        Map<T, Integer> map1 = CollUtils.countMap(coll1);
        Map<T, Integer> map2 = CollUtils.countMap(coll2);
        HashSet<T> elts = CollUtils.newHashSet(coll2);
        elts.addAll(coll1);
        for (Object t : elts) {
            int m = Math.abs(Convert.toInt(map1.get(t), 0) - Convert.toInt(map2.get(t), 0));
            for (int i = 0; i < m; ++i) {
                result.add(t);
            }
        }
        return result;
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return CollUtils.isNotEmpty(collection) && collection.contains(value);
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollUtils.isEmpty(coll1) || CollUtils.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            for (Object object : coll2) {
                if (!coll1.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> collection) {
        return IterUtils.countMap(collection);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        return IterUtils.join(iterable, conjunction);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return IterUtils.join(iterator, conjunction);
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (CollUtils.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (CollUtils.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return MapUtils.newHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        return MapUtils.newHashMap(size, isOrder);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtils.newHashMap(size);
    }

    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CollUtils.newHashSet(false, ts);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... ts) {
        return (LinkedHashSet)CollUtils.newHashSet(true, ts);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return CollUtils.newHashSet(false, collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        return isSorted ? new LinkedHashSet<T>(collection) : new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return CollUtils.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Enumeration<T> enumration) {
        HashSet set;
        if (null == enumration) {
            return CollUtils.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (enumration.hasMoreElements()) {
            set.add(enumration.nextElement());
        }
        return set;
    }

    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return CollUtils.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        for (T t : values) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        if (null == collection) {
            return CollUtils.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return CollUtils.list(isLinked);
        }
        return CollUtils.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list = CollUtils.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumration) {
        List<T> list = CollUtils.list(isLinked);
        if (null != enumration) {
            while (enumration.hasMoreElements()) {
                list.add(enumration.nextElement());
            }
        }
        return list;
    }

    public static <T> ArrayList<T> newArrayList(T ... values) {
        return (ArrayList)CollUtils.list(false, values);
    }

    public static <T> ArrayList<T> toList(T ... values) {
        return CollUtils.newArrayList(values);
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return (ArrayList)CollUtils.list(false, collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> iterable) {
        return (ArrayList)CollUtils.list(false, iterable);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iter) {
        return (ArrayList)CollUtils.list(false, iter);
    }

    public static <T> ArrayList<T> newArrayList(Enumeration<T> enumration) {
        return (ArrayList)CollUtils.list(false, enumration);
    }

    public static <T> LinkedList<T> newLinkedList(T ... values) {
        return (LinkedList)CollUtils.list(true, values);
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> BlockingQueue<T> newBlockingQueue(int capacity, boolean isLinked) {
        AbstractQueue queue = isLinked ? new LinkedBlockingDeque(capacity) : new ArrayBlockingQueue(capacity);
        return queue;
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        Collection<Object> list = null;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(ClassUtils.getTypeArgument(collectionType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ReflectUtils.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                throw new CommonException(e);
            }
        }
        return list;
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        return MapUtils.createMap(mapType);
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        if (CollUtils.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return CollUtils.sub(list, start, end, 1);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start == size) {
            return new ArrayList(0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > size) {
            if (start >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step <= 1) {
            return list.subList(start, end);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = start; i < end; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> List<T> sub(Collection<T> collection, int start, int end) {
        return CollUtils.sub(collection, start, end, 1);
    }

    public static <T> List<T> sub(Collection<T> list, int start, int end, int step) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return CollUtils.sub(new ArrayList<T>(list), start, end, step);
    }

    public static <T> List<List<T>> split(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> subList = new ArrayList<T>(size);
        for (T t : collection) {
            if (subList.size() >= size) {
                result.add(subList);
                subList = new ArrayList(size);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Editor<T> editor) {
        Collection<T> collection2 = ObjectUtils.clone(collection);
        try {
            collection2.clear();
        }
        catch (UnsupportedOperationException e) {
            collection2 = new ArrayList<T>();
        }
        for (T t : collection) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            collection2.add(modified);
        }
        return collection2;
    }

    public static <T> List<T> filter(List<T> list, Editor<T> editor) {
        AbstractList list2 = list instanceof LinkedList ? new LinkedList() : new ArrayList(list.size());
        for (T t : list) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list2.add(modified);
        }
        return list2;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Filter<T> filter) {
        Collection<T> collection2 = ObjectUtils.clone(collection);
        try {
            collection2.clear();
        }
        catch (UnsupportedOperationException e) {
            collection2 = new ArrayList<T>();
        }
        for (T t : collection) {
            if (!filter.accept(t)) continue;
            collection2.add(t);
        }
        return collection2;
    }

    public static <T> List<T> filter(List<T> list, Filter<T> filter) {
        AbstractList list2 = list instanceof LinkedList ? new LinkedList() : new ArrayList(list.size());
        for (T t : list) {
            if (!filter.accept(t)) continue;
            list2.add(t);
        }
        return list2;
    }

    public static <T> Collection<T> removeNull(Collection<T> collection) {
        return CollUtils.filter(collection, new Editor<T>(){

            @Override
            public T edit(T t) {
                return t;
            }
        });
    }

    public static <T> Collection<T> removeAny(Collection<T> collection, T ... elesRemoved) {
        collection.removeAll(CollUtils.newHashSet(elesRemoved));
        return collection;
    }

    public static <T extends CharSequence> Collection<T> removeEmpty(Collection<T> collection) {
        return CollUtils.filter(collection, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return false == StringUtils.isEmpty(t);
            }
        });
    }

    public static <T extends CharSequence> Collection<T> removeBlank(Collection<T> collection) {
        return CollUtils.filter(collection, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return false == StringUtils.isBlank(t);
            }
        });
    }

    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor) {
        ArrayList<Object> fieldValueList = new ArrayList<Object>();
        for (Object bean : collection) {
            fieldValueList.add(editor.edit(bean));
        }
        return fieldValueList;
    }

    public static List<Object> getFieldValues(Iterable<?> collection, final String fieldName) {
        return CollUtils.extract(collection, new Editor<Object>(){

            @Override
            public Object edit(Object bean) {
                if (bean instanceof Map) {
                    return ((Map)bean).get(fieldName);
                }
                return ReflectUtils.getFieldValue(bean, fieldName);
            }
        });
    }

    public static <T> T findOne(Iterable<T> collection, Filter<T> filter) {
        if (null != collection) {
            for (T t : collection) {
                if (!filter.accept(t)) continue;
                return t;
            }
        }
        return null;
    }

    public static <T> T findOneByField(Iterable<T> collection, final String fieldName, final Object fieldValue) {
        return CollUtils.findOne(collection, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                if (t instanceof Map) {
                    Map map = (Map)t;
                    Object value = map.get(fieldName);
                    return ObjectUtils.equal(value, fieldValue);
                }
                Object value = ReflectUtils.getFieldValue(t, fieldName);
                return ObjectUtils.equal(value, fieldValue);
            }
        });
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        return MapUtils.filter(map, editor);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        return MapUtils.filter(map, filter);
    }

    public static <T> int count(Iterable<T> iterable, Matcher<T> matcher) {
        int count = 0;
        if (null != iterable) {
            for (T t : iterable) {
                if (null != matcher && !matcher.match(t)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtils.isEmpty(map);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterUtils.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return IterUtils.isEmpty(Iterator2);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || false == enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return false == CollUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtils.isNotEmpty(map);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IterUtils.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return IterUtils.isNotEmpty(Iterator2);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IterUtils.hasNull(iterable);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayUtils.zip(StringUtils.split((CharSequence)keys, delimiter), StringUtils.split((CharSequence)values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollUtils.zip(keys, values, delimiter, false);
    }

    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        if (CollUtils.isEmpty(keys) || CollUtils.isEmpty(values)) {
            return null;
        }
        ArrayList<K> keyList = new ArrayList<K>(keys);
        ArrayList<V> valueList = new ArrayList<V>(values);
        int size = Math.min(keys.size(), values.size());
        HashMap map = new HashMap((int)((double)size / 0.75));
        for (int i = 0; i < size; ++i) {
            map.put(keyList.get(i), valueList.get(i));
        }
        return map;
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        return IterUtils.toMap(entryIter);
    }

    public static HashMap<Object, Object> toMap(Object[] array) {
        return MapUtils.of(array);
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        for (T t : collection) {
            treeSet.add(t);
        }
        return treeSet;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        return new IteratorEnumeration<E>(iter);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return IterUtils.asIterator(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return IterUtils.asIterable(iter);
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : CollUtils.newArrayList(iterable.iterator());
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        return MapUtils.toListMap(mapList);
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        return MapUtils.toMapList(listMap);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        return CollUtils.addAll(collection, value, TypeUtils.getTypeArgument(collection.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Iterator iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (null == elementType) {
            elementType = Object.class;
        } else {
            Class<?> elementRowType = TypeUtils.getClass((Type)elementType);
            if (elementRowType.isInstance(value) && !Iterable.class.isAssignableFrom(elementRowType)) {
                collection.add(value);
                return collection;
            }
        }
        if (value instanceof Iterator) {
            iter = (Iterator)value;
        } else if (value instanceof Iterable) {
            iter = ((Iterable)value).iterator();
        } else if (value instanceof Enumeration) {
            iter = new EnumerationIterator((Enumeration)value);
        } else if (ArrayUtils.isArray(value)) {
            iter = new ArrayIterator(value);
        } else {
            throw new CommonException("Unsupport value type " + value.getClass() + " !");
        }
        ConverterRegistry convert = ConverterRegistry.getInstance();
        while (iter.hasNext()) {
            try {
                collection.add(convert.convert((Type)elementType, iter.next()));
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        return CollUtils.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        if (null != collection && null != values) {
            for (T value : values) {
                collection.add(value);
            }
        }
        return collection;
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> T get(Collection<T> collection, int index) {
        int size = collection.size();
        if (index < 0) {
            index += size;
        }
        if (index >= size) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        int i = 0;
        for (T t : collection) {
            if (i > index) break;
            if (i == index) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>();
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        return IterUtils.getFirst(iterable);
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return IterUtils.getFirst(iterator);
    }

    public static <T> T getLast(Collection<T> collection) {
        return CollUtils.get(collection, -1);
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        return IterUtils.getElementType(iterable);
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        return IterUtils.getElementType(iterator);
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        ArrayList<V> values = new ArrayList<V>();
        for (K k : keys) {
            values.add(map.get(k));
        }
        return values;
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        return CollUtils.valuesOfKeys(map, keys.iterator());
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        ArrayList<V> values = new ArrayList<V>();
        while (keys.hasNext()) {
            values.add(map.get(keys.next()));
        }
        return values;
    }

    public static <T> List<T> sortPageAll(int pageNo, int pageSize, Comparator<T> comparator, Collection<T> ... colls) {
        ArrayList<T> list = new ArrayList<T>(pageNo * pageSize);
        for (Collection<T> coll : colls) {
            list.addAll(coll);
        }
        if (null != comparator) {
            Collections.sort(list, comparator);
        }
        return CollUtils.page(pageNo, pageSize, list);
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        if (CollUtils.isEmpty(list)) {
            return new ArrayList(0);
        }
        int resultSize = list.size();
        if (resultSize <= pageSize) {
            if (pageNo <= 1) {
                return Collections.unmodifiableList(list);
            }
            return new ArrayList(0);
        }
        int[] startEnd = CollUtils.transToStartEnd(pageNo, pageSize);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
        }
        return list.subList(startEnd[0], startEnd[1]);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list, comparator);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        Collections.sort(list, c);
        return list;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        Collections.sort(list, comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollUtils.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Object v1 = o1.getValue();
                Object v2 = o2.getValue();
                if (v1 instanceof Comparable) {
                    return ((Comparable)v1).compareTo(v2);
                }
                return v1.toString().compareTo(v2.toString());
            }
        });
        return list;
    }

    public static <T> void forEach(Iterator<T> iterator, Consumer<T> consumer) {
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, Consumer<T> consumer) {
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, KVConsumer<K, V> kvConsumer) {
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    public static <T> List<List<T>> group(Collection<T> collection, Hash<T> hash) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollUtils.isEmpty(collection)) {
            return result;
        }
        if (null == hash) {
            hash = new Hash<T>(){

                @Override
                public int hash(T t) {
                    return null == t ? 0 : t.hashCode();
                }
            };
        }
        for (T t : collection) {
            int index = hash.hash(t);
            if (result.size() - 1 < index) {
                while (result.size() - 1 < index) {
                    result.add(null);
                }
                result.set(index, CollUtils.newArrayList(t));
                continue;
            }
            List subList = (List)result.get(index);
            if (null == subList) {
                result.set(index, CollUtils.newArrayList(t));
                continue;
            }
            subList.add(t);
        }
        return result;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return CollUtils.filter(map, new Editor<Map.Entry<T, T>>(){

            @Override
            public Map.Entry<T, T> edit(final Map.Entry<T, T> t) {
                return new Map.Entry<T, T>(){

                    @Override
                    public T getKey() {
                        return t.getValue();
                    }

                    @Override
                    public T getValue() {
                        return t.getKey();
                    }

                    @Override
                    public T setValue(T value) {
                        throw new UnsupportedOperationException("Unsupported setValue method !");
                    }
                };
            }
        });
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> reverseNew(List<T> list) {
        List<T> list2 = ObjectUtils.clone(list);
        return CollUtils.reverse(list2);
    }

    public static <E> void sort(List<E> list, final boolean asc, final String ... name) {
        Collections.sort(list, new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                int ret = 0;
                try {
                    for (int i = 0; i < name.length && 0 == (ret = CollUtils.sort(name[i], asc, a, b)); ++i) {
                    }
                }
                catch (Exception e) {
                    throw new InstrumentException(e);
                }
                return ret;
            }
        });
    }

    public static <E> void sort(List<E> list, final String[] name, final boolean[] type) {
        if (name.length != type.length) {
            throw new RuntimeException("\u5c5e\u6027\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u548c\u5347\u964d\u5e8f\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u4e0d\u76f8\u7b49");
        }
        Collections.sort(list, new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                int ret = 0;
                try {
                    for (int i = 0; i < name.length && 0 == (ret = CollUtils.sort(name[i], type[i], a, b)); ++i) {
                    }
                }
                catch (Exception e) {
                    throw new InstrumentException(e);
                }
                return ret;
            }
        });
    }

    private static <E> int sort(String name, boolean asc, E a, E b) throws Exception {
        Object value1 = CollUtils.forceGetFieldValue(a, name);
        Object value2 = CollUtils.forceGetFieldValue(b, name);
        String str1 = value1.toString();
        String str2 = value2.toString();
        if (value1 instanceof Number && value2 instanceof Number) {
            int maxlen = Math.max(str1.length(), str2.length());
            str1 = NumberUtils.addZero((Number)value1, maxlen);
            str2 = NumberUtils.addZero((Number)value2, maxlen);
        } else if (value1 instanceof Date && value2 instanceof Date) {
            long time1 = ((Date)value1).getTime();
            long time2 = ((Date)value2).getTime();
            int maxlen = Long.toString(Math.max(time1, time2)).length();
            str1 = NumberUtils.addZero(time1, maxlen);
            str2 = NumberUtils.addZero(time2, maxlen);
        }
        if (asc) {
            return str1.compareTo(str2);
        }
        return str2.compareTo(str1);
    }

    public static Object forceGetFieldValue(Object obj, String fieldName) throws Exception {
        Field field = FieldUtils.getField(obj.getClass(), fieldName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
            obj = field.get(obj);
            field.setAccessible(accessible);
            return obj;
        }
        return field.get(obj);
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        if (index < list.size()) {
            list.set(index, element);
        } else {
            list.add(element);
        }
        return list;
    }

    public static int[] transToStartEnd(int pageNo, int pageSize) {
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 0;
        }
        int start = (pageNo - 1) * pageSize;
        int end = start + pageSize;
        return new int[]{start, end};
    }

    public static int totalPage(int totalCount, int pageSize) {
        if (pageSize == 0) {
            return 0;
        }
        return totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1;
    }

    public static int[] rainbow(int currentPage, int pageCount, int displayCount) {
        boolean isEven = true;
        isEven = displayCount % 2 == 0;
        int left = displayCount / 2;
        int right = displayCount / 2;
        int length = displayCount;
        if (isEven) {
            ++right;
        }
        if (pageCount < displayCount) {
            length = pageCount;
        }
        int[] result = new int[length];
        if (pageCount >= displayCount) {
            if (currentPage <= left) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + 1;
                }
            } else if (currentPage > pageCount - right) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + pageCount - displayCount + 1;
                }
            } else {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + currentPage - left + (isEven ? 1 : 0);
                }
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                result[i] = i + 1;
            }
        }
        return result;
    }

    public static int[] rainbow(int currentPage, int pageCount) {
        return CollUtils.rainbow(currentPage, pageCount, 10);
    }

    public static <T> Optional<T> firstNotNullElem(Collection<T> list) {
        if (CollUtils.isEmpty(list)) {
            return Optional.empty();
        }
        for (T elem : list) {
            if (!ObjectUtils.isNotNull(elem)) continue;
            return Optional.of(elem);
        }
        return Optional.empty();
    }

    public static interface Hash<T> {
        public int hash(T var1);
    }

    public static interface KVConsumer<K, V> {
        public void accept(K var1, V var2, int var3);
    }

    public static interface Consumer<T> {
        public void accept(T var1, int var2);
    }
}

