/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.thread.ExecutorBuilder;
import org.aoju.bus.core.thread.ThreadFactoryBuilder;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.cron.CronTimer;
import org.aoju.bus.cron.TaskExecutorManager;
import org.aoju.bus.cron.TaskLauncherManager;
import org.aoju.bus.cron.TaskTable;
import org.aoju.bus.cron.listener.TaskListener;
import org.aoju.bus.cron.listener.TaskListenerManager;
import org.aoju.bus.cron.pattern.CronPattern;
import org.aoju.bus.cron.task.InvokeTask;
import org.aoju.bus.cron.task.RunnableTask;
import org.aoju.bus.cron.task.Task;
import org.aoju.bus.setting.Setting;

public class Scheduler {
    protected boolean matchSecond = false;
    protected boolean daemon;
    protected TaskTable taskTable = new TaskTable(this);
    protected TaskLauncherManager taskLauncherManager;
    protected TaskExecutorManager taskExecutorManager;
    protected TaskListenerManager listenerManager = new TaskListenerManager();
    protected ExecutorService threadExecutor;
    private Object lock = new Object();
    private TimeZone timezone;
    private boolean started = false;
    private CronTimer timer;

    public TimeZone getTimeZone() {
        return this.timezone != null ? this.timezone : TimeZone.getDefault();
    }

    public Scheduler setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler setDaemon(boolean on) throws CommonException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new CommonException("Scheduler already started!");
            }
            this.daemon = on;
        }
        return this;
    }

    public boolean isDeamon() {
        return this.daemon;
    }

    public boolean isMatchSecond() {
        return this.matchSecond;
    }

    public Scheduler setMatchSecond(boolean isMatchSecond) {
        this.matchSecond = isMatchSecond;
        return this;
    }

    public Scheduler addListener(TaskListener listener) {
        this.listenerManager.addListener(listener);
        return this;
    }

    public Scheduler removeListener(TaskListener listener) {
        this.listenerManager.removeListener(listener);
        return this;
    }

    public Scheduler schedule(Setting cronSetting) {
        if (CollUtils.isNotEmpty(cronSetting)) {
            for (Map.Entry groupedEntry : cronSetting.getGroupedMap().entrySet()) {
                String group = (String)groupedEntry.getKey();
                for (Map.Entry entry : ((LinkedHashMap)groupedEntry.getValue()).entrySet()) {
                    String jobClass = (String)entry.getKey();
                    if (StringUtils.isNotBlank(group)) {
                        jobClass = group + "." + jobClass;
                    }
                    String pattern = (String)entry.getValue();
                    try {
                        this.schedule(pattern, new InvokeTask(jobClass));
                    }
                    catch (Exception e) {
                        throw new CommonException("Schedule [{}] [{}] error!", pattern, jobClass);
                    }
                }
            }
        }
        return this;
    }

    public String schedule(String pattern, Runnable task) {
        return this.schedule(pattern, new RunnableTask(task));
    }

    public String schedule(String pattern, Task task) {
        String id = UUID.randomUUID().toString();
        this.schedule(id, pattern, task);
        return id;
    }

    public Scheduler schedule(String id, String pattern, Runnable task) {
        return this.schedule(id, new CronPattern(pattern), (Task)new RunnableTask(task));
    }

    public Scheduler schedule(String id, String pattern, Task task) {
        return this.schedule(id, new CronPattern(pattern), task);
    }

    public Scheduler schedule(String id, CronPattern pattern, Task task) {
        this.taskTable.add(id, pattern, task);
        return this;
    }

    public Scheduler deschedule(String id) {
        this.taskTable.remove(id);
        return this;
    }

    public Scheduler updatePattern(String id, CronPattern pattern) {
        this.taskTable.updatePattern(id, pattern);
        return this;
    }

    public CronPattern getPattern(String id) {
        return this.taskTable.getPattern(id);
    }

    public Task getTask(String id) {
        return this.taskTable.getTask(id);
    }

    public boolean isEmpty() {
        return this.taskTable.isEmpty();
    }

    public int size() {
        return this.taskTable.size();
    }

    public Scheduler clear() {
        this.taskTable = new TaskTable(this);
        return this;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Scheduler start(boolean isDeamon) {
        this.daemon = isDeamon;
        return this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new CommonException("Schedule is started!");
            }
            this.threadExecutor = ExecutorBuilder.create().useSynchronousQueue().setThreadFactory(ThreadFactoryBuilder.create().setNamePrefix("exec-cron-").setDaemon(this.daemon).build()).build();
            this.taskLauncherManager = new TaskLauncherManager(this);
            this.taskExecutorManager = new TaskExecutorManager(this);
            this.timer = new CronTimer(this);
            this.timer.setDaemon(this.daemon);
            this.timer.start();
            this.started = true;
        }
        return this;
    }

    public Scheduler stop() {
        return this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler stop(boolean clearTasks) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started !");
            }
            this.timer.stopTimer();
            this.timer = null;
            this.threadExecutor.shutdown();
            this.threadExecutor = null;
            if (clearTasks) {
                this.clear();
            }
            this.started = false;
        }
        return this;
    }
}

