/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.text.csv.CsvData;
import org.aoju.bus.core.text.csv.CsvParser;
import org.aoju.bus.core.text.csv.CsvReadConfig;
import org.aoju.bus.core.text.csv.CsvRow;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.ObjectUtils;

public final class CsvReader {
    CsvReadConfig config;

    public CsvReader() {
        this(null);
    }

    public CsvReader(CsvReadConfig config) {
        this.config = ObjectUtils.defaultIfNull(config, CsvReadConfig.defaultConfig());
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws CommonException {
        return this.read(file, Charset.UTF_8);
    }

    public CsvData read(File file, java.nio.charset.Charset charset) throws CommonException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) throws CommonException {
        return this.read(path, Charset.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CsvData read(Path path, java.nio.charset.Charset charset) throws CommonException {
        Assert.notNull(path, "path must not be null", new Object[0]);
        try (BufferedReader reader = FileUtils.getReader(path, charset);){
            CsvData csvData = this.read(reader);
            return csvData;
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
    }

    public CsvData read(Reader reader) throws CommonException {
        CsvRow csvRow;
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        while ((csvRow = csvParser.nextRow()) != null) {
            rows.add(csvRow);
        }
        List<String> header = this.config.containsHeader ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    private CsvParser parse(Reader reader) throws CommonException {
        return new CsvParser(reader, this.config);
    }
}

