/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.poi.excel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.poi.excel.BigExcelWriter;
import org.aoju.bus.poi.excel.ExcelFileUtils;
import org.aoju.bus.poi.excel.ExcelReader;
import org.aoju.bus.poi.excel.ExcelWriter;
import org.aoju.bus.poi.excel.sax.Excel03SaxReader;
import org.aoju.bus.poi.excel.sax.Excel07SaxReader;
import org.aoju.bus.poi.excel.sax.RowHandler;

public class ExcelUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readBySax(String path, int sheetIndex, RowHandler rowHandler) {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(path);
            ExcelUtils.readBySax(in, sheetIndex, rowHandler);
        }
        finally {
            IoUtils.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readBySax(File file, int sheetIndex, RowHandler rowHandler) {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            ExcelUtils.readBySax(in, sheetIndex, rowHandler);
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static void readBySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        if (ExcelFileUtils.isXlsx(in = IoUtils.toMarkSupportStream(in))) {
            ExcelUtils.read07BySax(in, sheetIndex, rowHandler);
        } else {
            ExcelUtils.read03BySax(in, sheetIndex, rowHandler);
        }
    }

    public static Excel07SaxReader read07BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel07SaxReader(rowHandler).read(in, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static Excel07SaxReader read07BySax(File file, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel07SaxReader(rowHandler).read(file, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static Excel07SaxReader read07BySax(String path, int sheetIndex, RowHandler rowHandler) {
        try {
            return (Excel07SaxReader)new Excel07SaxReader(rowHandler).read(path, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static Excel03SaxReader read03BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel03SaxReader(rowHandler).read(in, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static Excel03SaxReader read03BySax(File file, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel03SaxReader(rowHandler).read(file, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static Excel03SaxReader read03BySax(String path, int sheetIndex, RowHandler rowHandler) {
        try {
            return (Excel03SaxReader)new Excel03SaxReader(rowHandler).read(path, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(String bookFilePath) {
        return ExcelUtils.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelUtils.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        try {
            return new ExcelReader(bookFilePath, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        try {
            return new ExcelReader(bookFile, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        try {
            return new ExcelReader(bookFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelUtils.getReader(bookStream, 0, true);
    }

    public static ExcelReader getReader(InputStream bookStream, boolean closeAfterRead) {
        try {
            return ExcelUtils.getReader(bookStream, 0, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        try {
            return new ExcelReader(bookStream, sheetIndex, true);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetIndex, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        try {
            return new ExcelReader(bookStream, sheetName, true);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetName, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getWriter() {
        try {
            return new ExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        try {
            return new ExcelWriter(isXlsx);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getWriter(String destFilePath) {
        try {
            return new ExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getWriter(File destFile) {
        try {
            return new ExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getWriter(String destFilePath, String sheetName) {
        try {
            return new ExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getWriter(File destFile, String sheetName) {
        try {
            return new ExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getBigWriter() {
        try {
            return new BigExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static ExcelWriter getBigWriter(int rowAccessWindowSize) {
        try {
            return new BigExcelWriter(rowAccessWindowSize);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath) {
        try {
            return new BigExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static BigExcelWriter getBigWriter(File destFile) {
        try {
            return new BigExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath, String sheetName) {
        try {
            return new BigExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static BigExcelWriter getBigWriter(File destFile, String sheetName) {
        try {
            return new BigExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 3.17");
        }
    }

    public static String indexToColName(int index) {
        int remainder;
        if (index < 0) {
            return null;
        }
        StringBuilder colName = StringUtils.builder();
        do {
            if (colName.length() > 0) {
                --index;
            }
            remainder = index % 26;
            colName.append((char)(remainder + 65));
        } while ((index = (index - remainder) / 26) > 0);
        return colName.reverse().toString();
    }

    public static int colNameToIndex(String colName) {
        char c;
        int length = colName.length();
        int index = -1;
        for (int i = 0; i < length && !Character.isDigit(c = Character.toUpperCase(colName.charAt(i))); ++i) {
            index = (index + 1) * 26 + c - 65;
        }
        return index;
    }
}

