/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.base.spring.BaseAdvice;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.sensitive.Builder;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.spring.sensitive.SensitiveProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@ControllerAdvice
@RestControllerAdvice
public class ResponseBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice<Object> {
    @Autowired
    SensitiveProperties properties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Annotation[] annotations = returnType.getDeclaringClass().getAnnotations();
        if (ArrayUtils.isNotEmpty(annotations)) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Sensitive)) continue;
                return true;
            }
        }
        return returnType.getMethod().isAnnotationPresent(Sensitive.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter parameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> converterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (ObjectUtils.isNotEmpty(this.properties) && !this.properties.isDebug()) {
            try {
                Sensitive sensitive = parameter.getMethod().getAnnotation(Sensitive.class);
                if (ObjectUtils.isEmpty(sensitive)) {
                    return body;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object obj : ((Message)body).getData() instanceof List ? (List<Object>)((Message)body).getData() : Arrays.asList(((Message)body).getData())) {
                    if ("ALL".equals(sensitive.value()) || "SENS".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "OUT".equals(sensitive.stage()))) {
                        obj = Builder.on(obj, sensitive);
                    }
                    if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value())) {
                        Map<String, Privacy> map = this.getPrivacyMap(obj.getClass());
                        for (Map.Entry<String, Privacy> entry : map.entrySet()) {
                            String property;
                            String value;
                            Privacy privacy = entry.getValue();
                            if (!ObjectUtils.isNotEmpty(privacy) || !StringUtils.isNotEmpty(privacy.value()) || !"ALL".equals(privacy.value()) && !"OUT".equals(privacy.value()) || !StringUtils.isNotEmpty(value = (String)ResponseBodyAdvice.getValue(obj, property = entry.getKey()))) continue;
                            if (ObjectUtils.isEmpty(this.properties)) {
                                throw new InstrumentException("please check the request.crypto.decrypt");
                            }
                            value = CryptoUtils.encrypt(this.properties.getEncrypt().getType(), this.properties.getEncrypt().getKey(), value, Charset.UTF_8);
                            ResponseBodyAdvice.setValue(obj, new String[]{property}, new String[]{value});
                        }
                    }
                    list.add(obj);
                }
                ((Message)body).setData(list);
            }
            catch (Exception e) {
                Logger.error("Internal processing failure:" + e.getMessage(), new Object[0]);
            }
        }
        return body;
    }

    private static <T> void setValue(T entity, String[] fields, Object[] value) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!ReflectUtils.hasField(entity, field)) continue;
            ReflectUtils.invokeSetter(entity, field, value[i]);
        }
    }

    private static <T> Object getValue(T entity, String field) {
        if (ReflectUtils.hasField(entity, field)) {
            Object object = ReflectUtils.invokeGetter(entity, field);
            return object != null ? object.toString() : null;
        }
        return null;
    }

    private Map<String, Privacy> getPrivacyMap(Class<?> clazz) {
        HashMap<String, Privacy> map = new HashMap<String, Privacy>();
        for (Field field : clazz.getDeclaredFields()) {
            Privacy privacy = field.getAnnotation(Privacy.class);
            if (privacy == null) continue;
            map.put(field.getName(), privacy);
        }
        return map;
    }
}

