/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.spring.servlet.BodyCacheHttpServletRequestWrapper;
import org.aoju.bus.spring.servlet.BodyCacheHttpServletResponseWrapper;
import org.aoju.bus.spring.servlet.RequestProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@EnableConfigurationProperties(value={RequestProperties.class})
public class RequestWrapperFilter {
    @Bean(value={"registrationBodyCacheFilter"})
    public FilterRegistrationBean registrationBodyCacheFilter(RequestProperties properties) {
        Set<String> servletNames;
        Set<ServletRegistrationBean<?>> registrationBeans;
        Map<String, String> initParameters;
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setEnabled(properties.getEnabled().booleanValue());
        registrationBean.setOrder(properties.getOrder());
        registrationBean.setFilter((Filter)new BodyCacheFilter());
        String name = properties.getName();
        if (!StringUtils.isEmpty((Object)name)) {
            registrationBean.setName(properties.getName());
        }
        if ((initParameters = properties.getInitParameters()) != null && initParameters.size() > 0) {
            registrationBean.setInitParameters(properties.getInitParameters());
        }
        if ((registrationBeans = properties.getServletRegistrationBeans()) != null && registrationBeans.size() > 0) {
            registrationBean.setServletRegistrationBeans(properties.getServletRegistrationBeans());
        }
        if (!CollectionUtils.isEmpty(servletNames = properties.getServletNames())) {
            registrationBean.setServletNames(properties.getServletNames());
        }
        return registrationBean;
    }

    private static class BodyCacheFilter
    extends OncePerRequestFilter {
        private BodyCacheFilter() {
        }

        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            String method = request.getMethod();
            if ((HttpMethod.POST.matches(method) || HttpMethod.PATCH.matches(method) || HttpMethod.PUT.matches(method)) && !(request instanceof BodyCacheHttpServletRequestWrapper)) {
                request = new BodyCacheHttpServletRequestWrapper((HttpServletRequest)request);
            }
            if (!(response instanceof BodyCacheHttpServletResponseWrapper)) {
                response = new BodyCacheHttpServletResponseWrapper((HttpServletResponse)response);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

