/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.poi.word;

import java.awt.Font;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.poi.word.DocUtils;
import org.aoju.bus.poi.word.TableUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class Word07Writer
implements Closeable {
    protected File destFile;
    protected boolean isClosed;
    private XWPFDocument doc;

    public Word07Writer() {
        this(new XWPFDocument());
    }

    public Word07Writer(File destFile) {
        this(DocUtils.create(destFile), destFile);
    }

    public Word07Writer(XWPFDocument doc) {
        this(doc, null);
    }

    public Word07Writer(XWPFDocument doc, File destFile) {
        this.doc = doc;
        this.destFile = destFile;
    }

    public XWPFDocument getDoc() {
        return this.doc;
    }

    public Word07Writer setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public Word07Writer addText(Font font, String ... texts) {
        return this.addText(null, font, texts);
    }

    public Word07Writer addText(ParagraphAlignment align, Font font, String ... texts) {
        XWPFParagraph p = this.doc.createParagraph();
        if (null != align) {
            p.setAlignment(align);
        }
        if (ArrayUtils.isNotEmpty(texts)) {
            for (String text : texts) {
                XWPFRun run = p.createRun();
                run.setText(text);
                if (null == font) continue;
                run.setFontFamily(font.getFamily());
                run.setFontSize(font.getSize());
                run.setBold(font.isBold());
                run.setItalic(font.isItalic());
            }
        }
        return this;
    }

    public Word07Writer addTable(Iterable<?> data) {
        TableUtils.createTable(this.doc, data);
        return this;
    }

    public Word07Writer flush() throws InstrumentException {
        return this.flush(this.destFile);
    }

    public Word07Writer flush(File destFile) throws InstrumentException {
        Assert.notNull(destFile, "[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", new Object[0]);
        return this.flush(FileUtils.getOutputStream(destFile), true);
    }

    public Word07Writer flush(OutputStream out) throws InstrumentException {
        return this.flush(out, false);
    }

    public Word07Writer flush(OutputStream out, boolean isCloseOut) throws InstrumentException {
        Assert.isFalse(this.isClosed, "WordWriter has been closed!", new Object[0]);
        try {
            this.doc.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (isCloseOut) {
                IoUtils.close(out);
            }
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        IoUtils.close((Closeable)this.doc);
        this.isClosed = true;
    }
}

