/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import org.aoju.bus.core.io.LineHandler;
import org.aoju.bus.core.io.watch.SimpleWatcher;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;

public class LineReadWatcher
extends SimpleWatcher
implements Runnable {
    private RandomAccessFile randomAccessFile;
    private Charset charset;
    private LineHandler lineHandler;

    public LineReadWatcher(RandomAccessFile randomAccessFile, Charset charset, LineHandler lineHandler) {
        this.randomAccessFile = randomAccessFile;
        this.charset = charset;
        this.lineHandler = lineHandler;
    }

    @Override
    public void run() {
        this.onModify(null, null);
    }

    @Override
    public void onModify(WatchEvent<?> event, Path currentPath) {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        Charset charset = this.charset;
        LineHandler lineHandler = this.lineHandler;
        try {
            long currentLength = randomAccessFile.length();
            long position = randomAccessFile.getFilePointer();
            if (0L == currentLength || position == currentLength) {
                return;
            }
            if (currentLength < position) {
                randomAccessFile.seek(currentLength);
                return;
            }
            FileUtils.readLines(randomAccessFile, charset, lineHandler);
            randomAccessFile.seek(currentLength);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }
}

