/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.aoju.bus.cache.support.serialize.AbstractSerializer;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.logger.Logger;

public class JdkSerializer
extends AbstractSerializer {
    private static void serialize(Serializable obj, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(obj);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserialize(InputStream inputStream) {
        Object result;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            result = in.readObject();
        }
        catch (IOException | ClassCastException | ClassNotFoundException ce) {
            try {
                throw new CommonException(ce);
            }
            catch (Throwable throwable) {
                try {
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error(e, "close stream failed when deserialize error: ", e.getMessage());
                }
                throw throwable;
            }
        }
        try {
            if (in == null) return result;
            in.close();
            return result;
        }
        catch (IOException e) {
            Logger.error(e, "close stream failed when deserialize error: ", e.getMessage());
            return result;
        }
    }

    @Override
    protected byte[] doSerialize(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        JdkSerializer.serialize((Serializable)obj, baos);
        return baos.toByteArray();
    }

    @Override
    protected Object doDeserialize(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return JdkSerializer.deserialize(new ByteArrayInputStream(bytes));
    }
}

