/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.aio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.thread.ThreadFactoryBuilder;
import org.aoju.bus.socket.origin.OriginConfig;
import org.aoju.bus.socket.origin.aio.AioSession;
import org.aoju.bus.socket.origin.aio.IoAction;

public class AioClient {
    private AioSession session;

    public AioClient(InetSocketAddress address, IoAction<ByteBuffer> ioAction) {
        this(address, ioAction, new OriginConfig());
    }

    public AioClient(InetSocketAddress address, IoAction<ByteBuffer> ioAction, OriginConfig config) {
        this(AioClient.createChannel(address, config.getThreadPoolSize()), ioAction, config);
    }

    public AioClient(AsynchronousSocketChannel channel, IoAction<ByteBuffer> ioAction, OriginConfig config) {
        this.session = new AioSession(channel, ioAction, config);
        ioAction.accept(this.session);
    }

    private static AsynchronousSocketChannel createChannel(InetSocketAddress address, int poolSize) {
        AsynchronousSocketChannel channel;
        try {
            AsynchronousChannelGroup group = AsynchronousChannelGroup.withFixedThreadPool(poolSize, ThreadFactoryBuilder.create().setNamePrefix("hi-socket-").build());
            channel = AsynchronousSocketChannel.open(group);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        try {
            channel.connect(address).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CommonException(e);
        }
        return channel;
    }

    public <T> AioClient setOption(SocketOption<T> name, T value) throws IOException {
        this.session.getChannel().setOption((SocketOption)name, (Object)value);
        return this;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.session.getIoAction();
    }

    public AioClient read() {
        this.session.read();
        return this;
    }

    public AioClient write(ByteBuffer data) {
        this.session.write(data);
        return this;
    }

    public void close() {
        this.session.close();
    }
}

