/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.storage;

import java.util.Map;
import org.aoju.bus.spring.annotation.EnableStorage;
import org.aoju.bus.spring.storage.StorageConfiguration;
import org.aoju.bus.storage.Provider;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public class StorageImportSelector
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment env;

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EnableStorage.class.getName(), true));
        Assert.notNull((Object)attributes, (String)("No auto-configuration attributes found. Is " + metadata.getClassName() + " annotated with @EnableStorage?"));
        Provider provider = (Provider)attributes.getEnum("provider");
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(StorageConfiguration.class);
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.addPropertyValue("provider", (Object)provider.getValue());
        propertyValues.addPropertyValue("endpoint", (Object)this.env.getProperty("oss.endpoint", ""));
        propertyValues.addPropertyValue("accessKey", (Object)this.env.getProperty("oss.accessKey", ""));
        propertyValues.addPropertyValue("secretKey", (Object)this.env.getProperty("oss.secretKey", ""));
        propertyValues.addPropertyValue("urlPrefix", (Object)this.env.getProperty("oss.url-prefix", ""));
        propertyValues.addPropertyValue("privated", (Object)this.env.getProperty("oss.privated", "false"));
        propertyValues.addPropertyValue("bucket", (Object)this.env.getProperty("oss.bucket", ""));
        propertyValues.addPropertyValue("internalUrl", (Object)this.env.getProperty("oss.internal-url", ""));
        beanDefinition.setPropertyValues(propertyValues);
        beanDefinitionRegistry.registerBeanDefinition("ossProviderSpingFacade", (BeanDefinition)beanDefinition);
    }
}

