/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.xss;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.EscapeUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.spring.xss.XssFilter;
import org.aoju.bus.spring.xss.XssProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@EnableConfigurationProperties(value={XssProperties.class})
public class XssConfiguration {
    @Autowired(required=false)
    private XssProperties xssProperties;

    @Bean
    public FilterRegistrationBean registrationXssFilter(XssProperties properties) {
        Set<String> servletNames;
        Set<ServletRegistrationBean<?>> registrationBeans;
        Map<String, String> initParameters;
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setEnabled(true);
        registrationBean.setOrder(properties.getOrder());
        registrationBean.setFilter((Filter)new XssFilter());
        String name = properties.getName();
        if (!StringUtils.isEmpty(name)) {
            registrationBean.setName(properties.getName());
        }
        if ((initParameters = properties.getInitParameters()) != null && initParameters.size() > 0) {
            registrationBean.setInitParameters(properties.getInitParameters());
        }
        if ((registrationBeans = properties.getServletRegistrationBeans()) != null && registrationBeans.size() > 0) {
            registrationBean.setServletRegistrationBeans(properties.getServletRegistrationBeans());
        }
        if (!CollUtils.isEmpty(servletNames = properties.getServletNames())) {
            registrationBean.setServletNames(properties.getServletNames());
        }
        return registrationBean;
    }

    @Bean
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        SimpleModule simpleModule = new SimpleModule("commonJsonSerializer");
        simpleModule.addSerializer((JsonSerializer)new CommonJsonSerializer(this.xssProperties));
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }

    static class CommonJsonSerializer
    extends JsonSerializer<String> {
        private XssProperties xssProperties;

        CommonJsonSerializer(XssProperties xssProperties) {
            this.xssProperties = xssProperties;
        }

        public Class<String> handledType() {
            return String.class;
        }

        public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (value != null && this.xssProperties != null) {
                value = EscapeUtils.escapeHtml4(value);
                jsonGenerator.writeString(value);
            }
        }
    }
}

