/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.aoju.bus.core.consts.FileType;
import org.aoju.bus.core.io.BOMInputStream;
import org.aoju.bus.core.io.LineHandler;
import org.aoju.bus.core.io.file.FileCopier;
import org.aoju.bus.core.io.file.FileReader;
import org.aoju.bus.core.io.file.FileWriter;
import org.aoju.bus.core.io.file.LineSeparator;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CharUtils;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.PatternUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.UriUtils;

public class FileUtils {
    private static Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|]");

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static String readFile(File file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new java.io.FileReader(file));
            String tempString = null;
            String all = "";
            while ((tempString = reader.readLine()) != null) {
                all = all + tempString;
            }
            reader.close();
            String string = all;
            return string;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File[] ls(String path) {
        if (path == null) {
            return null;
        }
        File file = FileUtils.file(path = FileUtils.getAbsolutePath(path));
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new InstrumentException(StringUtils.format("Path [{}] is not directory!", path));
    }

    public static boolean isEmpty(File file) {
        if (null == file) {
            return true;
        }
        if (file.isDirectory()) {
            Object[] subFiles = file.list();
            return ArrayUtils.isEmpty(subFiles);
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return false == FileUtils.isEmpty(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path dirPath) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            boolean bl = false == dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean isDirEmpty(File dir) {
        return FileUtils.isDirEmpty(dir.toPath());
    }

    public static List<File> loopFiles(String path, FileFilter fileFilter) {
        return FileUtils.loopFiles(FileUtils.file(path), fileFilter);
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (null == file) {
            return fileList;
        }
        if (!file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (ArrayUtils.isNotEmpty(subFiles)) {
                for (File tmp : subFiles) {
                    fileList.addAll(FileUtils.loopFiles(tmp, fileFilter));
                }
            }
        } else if (null == fileFilter || fileFilter.accept(file)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static List<File> loopFiles(String path) {
        return FileUtils.loopFiles(FileUtils.file(path));
    }

    public static List<File> loopFiles(File file) {
        return FileUtils.loopFiles(file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listFileNames(String path) throws InstrumentException {
        if (path == null) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        int index = path.lastIndexOf(".jar!");
        if (index == -1) {
            File[] files;
            File[] fileArray = files = FileUtils.ls(path);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    paths.add(file.getName());
                }
                ++n2;
            }
            return paths;
        }
        if (!StringUtils.endWith((CharSequence)(path = FileUtils.getAbsolutePath(path)), '/')) {
            path = path + '/';
        }
        index += ".jar".length();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path.substring(0, index));
            String subPath = path.substring(index + 2);
            for (JarEntry entry : Collections.list(jarFile.entries())) {
                String nameSuffix;
                String name = entry.getName();
                if (!name.startsWith(subPath) || StringUtils.contains(nameSuffix = StringUtils.removePrefix(name, subPath), '/')) continue;
                paths.add(nameSuffix);
            }
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(StringUtils.format("Can not read file path of [{}]", path), e);
            }
            catch (Throwable throwable) {
                IoUtils.close(jarFile);
                throw throwable;
            }
        }
        IoUtils.close(jarFile);
        return paths;
    }

    public static File newFile(String path) {
        return new File(path);
    }

    public static File file(String path) {
        if (StringUtils.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(FileUtils.getAbsolutePath(path));
    }

    public static File file(String parent, String path) {
        return FileUtils.file(new File(parent), path);
    }

    public static File file(File parent, String path) {
        if (StringUtils.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileUtils.checkSlip(parent, new File(parent, path));
    }

    public static File file(File directory, String ... names) {
        Assert.notNull(directory, "directorydirectory must not be null", new Object[0]);
        if (ArrayUtils.isEmpty(names)) {
            return directory;
        }
        File file = directory;
        for (String name : names) {
            if (null == name) continue;
            file = FileUtils.file(file, name);
        }
        return file;
    }

    public static File file(String ... names) {
        if (ArrayUtils.isEmpty(names)) {
            return null;
        }
        File file = null;
        for (String name : names) {
            file = file == null ? FileUtils.file(name) : FileUtils.file(file, name);
        }
        return file;
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(UriUtils.toURI(url));
    }

    public static String getTmpDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTmpDir() {
        return FileUtils.file(FileUtils.getTmpDirPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHomeDir() {
        return FileUtils.file(FileUtils.getUserHomePath());
    }

    public static boolean exist(String path) {
        return path != null && FileUtils.file(path).exists();
    }

    public static boolean exist(File file) {
        return file != null && file.exists();
    }

    public static boolean exist(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        if (!FileUtils.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        return FileUtils.lastModifiedTime(new File(path));
    }

    public static long size(File file) {
        Assert.notNull(file, "file argument is null !", new Object[0]);
        if (!file.exists()) {
            throw new IllegalArgumentException(StringUtils.format("File [{}] not exist !", file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            long size = 0L;
            Object[] subFiles = file.listFiles();
            if (ArrayUtils.isEmpty(subFiles)) {
                return 0L;
            }
            for (int i = 0; i < subFiles.length; ++i) {
                size += FileUtils.size((File)subFiles[i]);
            }
            return size;
        }
        return file.length();
    }

    public static boolean newerThan(File file, File reference) {
        if (null == reference || !reference.exists()) {
            return true;
        }
        return FileUtils.newerThan(file, reference.lastModified());
    }

    public static boolean newerThan(File file, long timeMillis) {
        if (null == file || !file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static File touch(String fullFilePath) throws InstrumentException {
        if (fullFilePath == null) {
            return null;
        }
        return FileUtils.touch(FileUtils.file(fullFilePath));
    }

    public static File touch(File file) throws InstrumentException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtils.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
        }
        return file;
    }

    public static File touch(File parent, String path) throws InstrumentException {
        return FileUtils.touch(FileUtils.file(parent, path));
    }

    public static File touch(String parent, String path) throws InstrumentException {
        return FileUtils.touch(FileUtils.file(parent, path));
    }

    public static File mkParentDirs(File file) {
        File parentFile = file.getParentFile();
        if (null != parentFile && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile;
    }

    public static File mkParentDirs(String path) {
        if (path == null) {
            return null;
        }
        return FileUtils.mkParentDirs(FileUtils.file(path));
    }

    public static boolean del(String fullFileOrDirPath) throws InstrumentException {
        return FileUtils.del(FileUtils.file(fullFileOrDirPath));
    }

    public static boolean del(File file) throws InstrumentException {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            FileUtils.clean(file);
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return true;
    }

    public static boolean clean(String dirPath) throws InstrumentException {
        return FileUtils.clean(FileUtils.file(dirPath));
    }

    public static boolean clean(File directory) throws InstrumentException {
        File[] files;
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        for (File childFile : files = directory.listFiles()) {
            boolean isOk = FileUtils.del(childFile);
            if (isOk) continue;
            return false;
        }
        return true;
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileUtils.file(dirPath);
        return FileUtils.mkdir(dir);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File createTempFile(File dir) throws InstrumentException {
        return FileUtils.createTempFile("create", null, dir, true);
    }

    public static File createTempFile(File dir, boolean isReCreat) throws InstrumentException {
        return FileUtils.createTempFile("create", null, dir, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws InstrumentException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, dir).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new InstrumentException(ioex);
            }
            break;
        }
    }

    public static File copyFile(String src, String dest, StandardCopyOption ... options) throws InstrumentException {
        Assert.notBlank(src, "Source File path is blank !", new Object[0]);
        Assert.notNull(src, "Destination File path is null !", new Object[0]);
        return FileUtils.copyFile(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), options).toFile();
    }

    public static File copyFile(File src, File dest, StandardCopyOption ... options) throws InstrumentException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new InstrumentException("File not exist: " + src);
        }
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        if (FileUtils.equals(src, dest)) {
            throw new InstrumentException("Files '{}' and '{}' are equal", src, dest);
        }
        return FileUtils.copyFile(src.toPath(), dest.toPath(), options).toFile();
    }

    public static Path copyFile(Path src, Path dest, StandardCopyOption ... options) throws InstrumentException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        Path destPath = dest.toFile().isDirectory() ? dest.resolve(src.getFileName()) : dest;
        try {
            return Files.copy(src, destPath, (CopyOption[])options);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static File copy(String srcPath, String destPath, boolean isOverride) throws InstrumentException {
        return FileUtils.copy(FileUtils.file(srcPath), FileUtils.file(destPath), isOverride);
    }

    public static File copy(File src, File dest, boolean isOverride) throws InstrumentException {
        return FileCopier.create(src, dest).setOverride(isOverride).copy();
    }

    public static File copyContent(File src, File dest, boolean isOverride) throws InstrumentException {
        return FileCopier.create(src, dest).setCopyContentIfDir(true).setOverride(isOverride).copy();
    }

    public static File copyFilesFromDir(File src, File dest, boolean isOverride) throws InstrumentException {
        return FileCopier.create(src, dest).setCopyContentIfDir(true).setOnlyCopyFile(true).setOverride(isOverride).copy();
    }

    public static void move(File src, File dest, boolean isOverride) throws InstrumentException {
        if (!src.exists()) {
            throw new InstrumentException("File not found: " + src);
        }
        if (src.isDirectory() && dest.isFile()) {
            throw new InstrumentException(StringUtils.format("Can not move directory [{}] to file [{}]", src, dest));
        }
        if (isOverride && dest.isFile()) {
            dest.delete();
        }
        if (src.isFile() && dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (!src.renameTo(dest)) {
            try {
                FileUtils.copy(src, dest, isOverride);
                src.delete();
            }
            catch (Exception e) {
                throw new InstrumentException(StringUtils.format("Move [{}] to [{}] failed!", src, dest), e);
            }
        }
    }

    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        CopyOption[] copyOptionArray;
        if (isRetainExt) {
            newName = newName.concat(".").concat(FileUtils.extName(file));
        }
        Path path = file.toPath();
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        try {
            return Files.move(path, path.resolveSibling(newName), options).toFile();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String getCanonicalPath(File file) {
        if (null == file) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = FileUtils.normalize(path);
            if (FileUtils.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceUtils.getResource(normalPath, baseClass);
        if (null != url) {
            return FileUtils.normalize(UriUtils.getDecodedPath(url));
        }
        String classPath = ClassUtils.getClassPath();
        if (null == classPath) {
            return path;
        }
        return FileUtils.normalize(classPath.concat(path));
    }

    public static String getAbsolutePath(String path) {
        return FileUtils.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || path.matches("^[a-zA-Z]:[/\\\\].*");
    }

    public static boolean isDirectory(String path) {
        return path != null && FileUtils.file(path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return file != null && file.isDirectory();
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isDirectory(path, options);
    }

    public static boolean isFile(String path) {
        return path != null && FileUtils.file(path).isFile();
    }

    public static boolean isFile(File file) {
        return file != null && file.isFile();
    }

    public static boolean isFile(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isRegularFile(path, options);
    }

    public static boolean equals(File file1, File file2) throws InstrumentException {
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return false == file1.exists() && false == file2.exists() && FileUtils.pathEquals(file1, file2);
        }
        try {
            return Files.isSameFile(file1.toPath(), file2.toPath());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file1, File file2) throws InstrumentException {
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new InstrumentException("Can't compare directories, only file");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileUtils.equals(file1, file2)) {
            return true;
        }
        BufferedInputStream input1 = null;
        BufferedInputStream input2 = null;
        try {
            input1 = FileUtils.getInputStream(file1);
            input2 = FileUtils.getInputStream(file2);
            boolean bl = IoUtils.contentEquals(input1, input2);
            return bl;
        }
        finally {
            IoUtils.close(input1);
            IoUtils.close(input2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEqualsIgnoreEOL(File file1, File file2, Charset charset) throws InstrumentException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new InstrumentException("Can't compare directories, only file");
        }
        if (FileUtils.equals(file1, file2)) {
            return true;
        }
        BufferedReader input1 = null;
        BufferedReader input2 = null;
        try {
            input1 = FileUtils.getReader(file1, charset);
            input2 = FileUtils.getReader(file2, charset);
            bl = IoUtils.contentEqualsIgnoreEOL(input1, input2);
        }
        catch (Throwable throwable) {
            IoUtils.close(input1);
            IoUtils.close(input2);
            throw throwable;
        }
        IoUtils.close(input1);
        IoUtils.close(input2);
        return bl;
    }

    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (FileUtils.isWindows()) {
                try {
                    if (StringUtils.equalsIgnoreCase(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (StringUtils.equalsIgnoreCase(file1.getAbsolutePath(), file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StringUtils.equals(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!StringUtils.equals(file1.getAbsolutePath(), file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (StringUtils.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (i-- >= 0) {
                char c = filePath.charAt(i);
                if (!CharUtils.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isModifed(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.removePrefixIgnoreCase(path, "classpath:");
        pathToUse = StringUtils.removePrefixIgnoreCase(pathToUse, "file:");
        pathToUse = pathToUse.replaceAll("[/\\\\]{1,}", "/").trim();
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (StringUtils.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StringUtils.split(pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        return prefix + CollUtils.join(pathElements, (CharSequence)"/");
    }

    public static String subPath(String rootDir, File file) {
        try {
            return FileUtils.subPath(rootDir, file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String subPath(String dirPath, String filePath) {
        if (StringUtils.isNotEmpty(dirPath) && StringUtils.isNotEmpty(filePath)) {
            dirPath = StringUtils.removeSuffix(FileUtils.normalize(dirPath), "/");
            filePath = FileUtils.normalize(filePath);
            String result = StringUtils.removePrefixIgnoreCase(filePath, dirPath);
            return StringUtils.removePrefix(result, "/");
        }
        return filePath;
    }

    public static Path getPathEle(Path path, int index) {
        return FileUtils.subPath(path, index, index == -1 ? path.getNameCount() : index + 1);
    }

    public static Path getLastPathEle(Path path) {
        return FileUtils.getPathEle(path, path.getNameCount() - 1);
    }

    public static Path subPath(Path path, int fromIndex, int toIndex) {
        if (null == path) {
            return null;
        }
        int len = path.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path.subpath(fromIndex, toIndex);
    }

    public static String getName(File file) {
        return null != file ? file.getName() : null;
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return filePath;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (CharUtils.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!CharUtils.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileUtils.mainName(file.getName());
    }

    public static String mainName(String fileName) {
        if (null == fileName) {
            return fileName;
        }
        int len = fileName.length();
        if (0 == len) {
            return fileName;
        }
        if (CharUtils.isFileSeparator(fileName.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        int end = len;
        for (int i = len - 1; i > -1; --i) {
            char c = fileName.charAt(i);
            if (len == end && '.' == c) {
                end = i;
            }
            if (0 != begin && begin <= end || !CharUtils.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return fileName.substring(begin, end);
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileUtils.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return StringUtils.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static boolean pathEndsWith(File file, String suffix) {
        return file.getPath().toLowerCase().endsWith(suffix);
    }

    public static String getType(File file) throws InstrumentException {
        return FileType.getType(file);
    }

    public static BasicFileAttributes getAttributes(Path path, boolean isFollowLinks) throws InstrumentException {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return null;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedInputStream getInputStream(Path path) throws InstrumentException {
        try {
            return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedInputStream getInputStream(File file) throws InstrumentException {
        return new BufferedInputStream(IoUtils.toStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws InstrumentException {
        return FileUtils.getInputStream(FileUtils.file(path));
    }

    public static BOMInputStream getBOMInputStream(File file) throws InstrumentException {
        try {
            return new BOMInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedReader getUtf8Reader(Path path) throws InstrumentException {
        return FileUtils.getReader(path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static BufferedReader getUtf8Reader(File file) throws InstrumentException {
        return FileUtils.getReader(file, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static BufferedReader getUtf8Reader(String path) throws InstrumentException {
        return FileUtils.getReader(path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static BufferedReader getReader(Path path, Charset charset) throws InstrumentException {
        return IoUtils.getReader((InputStream)FileUtils.getInputStream(path), charset);
    }

    public static BufferedReader getReader(File file, String charsetName) throws InstrumentException {
        return IoUtils.getReader((InputStream)FileUtils.getInputStream(file), charsetName);
    }

    public static BufferedReader getReader(File file, Charset charset) throws InstrumentException {
        return IoUtils.getReader((InputStream)FileUtils.getInputStream(file), charset);
    }

    public static BufferedReader getReader(String path, String charsetName) throws InstrumentException {
        return FileUtils.getReader(FileUtils.file(path), charsetName);
    }

    public static BufferedReader getReader(String path, Charset charset) throws InstrumentException {
        return FileUtils.getReader(FileUtils.file(path), charset);
    }

    public static byte[] readBytes(File file) throws InstrumentException {
        return FileReader.create(file).readBytes();
    }

    public static byte[] readBytes(String filePath) throws InstrumentException {
        return FileUtils.readBytes(FileUtils.file(filePath));
    }

    public static String readUtf8String(File file) throws InstrumentException {
        return FileUtils.readString(file, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static String readUtf8String(String path) throws InstrumentException {
        return FileUtils.readString(path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static String readString(File file, String charsetName) throws InstrumentException {
        return FileUtils.readString(file, CharsetUtils.charset(charsetName));
    }

    public static String readString(File file, Charset charset) throws InstrumentException {
        return FileReader.create(file, charset).readString();
    }

    public static String readString(String path, String charsetName) throws InstrumentException {
        return FileUtils.readString(FileUtils.file(path), charsetName);
    }

    public static String readString(String path, Charset charset) throws InstrumentException {
        return FileUtils.readString(FileUtils.file(path), charset);
    }

    public static String readString(URL url, String charset) throws InstrumentException {
        if (url == null) {
            throw new NullPointerException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoUtils.read(in, charset);
            return string;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static <T extends Collection<String>> T readUtf8Lines(String path, T collection) throws InstrumentException {
        return FileUtils.readLines(path, org.aoju.bus.core.consts.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws InstrumentException {
        return FileUtils.readLines(FileUtils.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(String path, Charset charset, T collection) throws InstrumentException {
        return FileUtils.readLines(FileUtils.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(File file, T collection) throws InstrumentException {
        return FileUtils.readLines(file, org.aoju.bus.core.consts.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, String charset, T collection) throws InstrumentException {
        return FileReader.create(file, CharsetUtils.charset(charset)).readLines(collection);
    }

    public static <T extends Collection<String>> T readLines(File file, Charset charset, T collection) throws InstrumentException {
        return FileReader.create(file, charset).readLines(collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(URL url, T collection) throws InstrumentException {
        return FileUtils.readLines(url, org.aoju.bus.core.consts.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, String charsetName, T collection) throws InstrumentException {
        return FileUtils.readLines(url, CharsetUtils.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, Charset charset, T collection) throws InstrumentException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoUtils.readLines(in, charset, collection);
            return t;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static List<String> readUtf8Lines(URL url) throws InstrumentException {
        return FileUtils.readLines(url, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static List<String> readLines(URL url, String charset) throws InstrumentException {
        return FileUtils.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(URL url, Charset charset) throws InstrumentException {
        return FileUtils.readLines(url, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(String path) throws InstrumentException {
        return FileUtils.readLines(path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static List<String> readLines(String path, String charset) throws InstrumentException {
        return FileUtils.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(String path, Charset charset) throws InstrumentException {
        return FileUtils.readLines(path, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(File file) throws InstrumentException {
        return FileUtils.readLines(file, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static List<String> readLines(File file, String charset) throws InstrumentException {
        return FileUtils.readLines(file, charset, new ArrayList());
    }

    public static List<String> readLines(File file, Charset charset) throws InstrumentException {
        return FileUtils.readLines(file, charset, new ArrayList());
    }

    public static void readUtf8Lines(File file, LineHandler lineHandler) throws InstrumentException {
        FileUtils.readLines(file, org.aoju.bus.core.consts.Charset.UTF_8, lineHandler);
    }

    public static void readLines(File file, Charset charset, LineHandler lineHandler) throws InstrumentException {
        FileReader.create(file, charset).readLines(lineHandler);
    }

    public static void readLines(RandomAccessFile file, Charset charset, LineHandler lineHandler) {
        String line = null;
        try {
            while ((line = file.readLine()) != null) {
                lineHandler.handle(CharsetUtils.convert(line, org.aoju.bus.core.consts.Charset.ISO_8859_1, charset));
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void readLine(RandomAccessFile file, Charset charset, LineHandler lineHandler) {
        String line = FileUtils.readLine(file, charset);
        if (null != line) {
            lineHandler.handle(line);
        }
    }

    public static String readLine(RandomAccessFile file, Charset charset) {
        String line = null;
        try {
            line = file.readLine();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        if (null != line) {
            return CharsetUtils.convert(line, org.aoju.bus.core.consts.Charset.ISO_8859_1, charset);
        }
        return null;
    }

    public static <T> T loadUtf8(String path, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileUtils.load(path, org.aoju.bus.core.consts.Charset.UTF_8, readerHandler);
    }

    public static <T> T load(String path, String charset, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileReader.create(FileUtils.file(path), CharsetUtils.charset(charset)).read(readerHandler);
    }

    public static <T> T load(String path, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileReader.create(FileUtils.file(path), charset).read(readerHandler);
    }

    public static <T> T loadUtf8(File file, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileUtils.load(file, org.aoju.bus.core.consts.Charset.UTF_8, readerHandler);
    }

    public static <T> T load(File file, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileReader.create(file, charset).read(readerHandler);
    }

    public static BufferedOutputStream getOutputStream(File file) throws InstrumentException {
        try {
            return new BufferedOutputStream(new FileOutputStream(FileUtils.touch(file)));
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedOutputStream getOutputStream(String path) throws InstrumentException {
        return FileUtils.getOutputStream(FileUtils.touch(path));
    }

    public static BufferedWriter getWriter(String path, String charsetName, boolean isAppend) throws InstrumentException {
        return FileUtils.getWriter(FileUtils.touch(path), Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws InstrumentException {
        return FileUtils.getWriter(FileUtils.touch(path), charset, isAppend);
    }

    public static BufferedWriter getWriter(File file, String charsetName, boolean isAppend) throws InstrumentException {
        return FileUtils.getWriter(file, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, charset).getWriter(isAppend);
    }

    public static PrintWriter getPrintWriter(String path, String charset, boolean isAppend) throws InstrumentException {
        return new PrintWriter(FileUtils.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(String path, Charset charset, boolean isAppend) throws InstrumentException {
        return new PrintWriter(FileUtils.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, String charset, boolean isAppend) throws InstrumentException {
        return new PrintWriter(FileUtils.getWriter(file, charset, isAppend));
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static File writeUtf8String(String content, String path) throws InstrumentException {
        return FileUtils.writeString(content, path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static File writeUtf8String(String content, File file) throws InstrumentException {
        return FileUtils.writeString(content, file, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static File writeString(String content, String path, String charset) throws InstrumentException {
        return FileUtils.writeString(content, FileUtils.touch(path), charset);
    }

    public static File writeString(String content, String path, Charset charset) throws InstrumentException {
        return FileUtils.writeString(content, FileUtils.touch(path), charset);
    }

    public static File writeString(String content, File file, String charset) throws InstrumentException {
        return FileWriter.create(file, CharsetUtils.charset(charset)).write(content);
    }

    public static File writeString(String content, File file, Charset charset) throws InstrumentException {
        return FileWriter.create(file, charset).write(content);
    }

    public static File appendUtf8String(String content, String path) throws InstrumentException {
        return FileUtils.appendString(content, path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static File appendString(String content, String path, String charset) throws InstrumentException {
        return FileUtils.appendString(content, FileUtils.touch(path), charset);
    }

    public static File appendString(String content, String path, Charset charset) throws InstrumentException {
        return FileUtils.appendString(content, FileUtils.touch(path), charset);
    }

    public static File appendUtf8String(String content, File file) throws InstrumentException {
        return FileUtils.appendString(content, file, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static File appendString(String content, File file, String charset) throws InstrumentException {
        return FileWriter.create(file, CharsetUtils.charset(charset)).append(content);
    }

    public static File appendString(String content, File file, Charset charset) throws InstrumentException {
        return FileWriter.create(file, charset).append(content);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, String path) throws InstrumentException {
        return FileUtils.writeLines(list, path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, File file) throws InstrumentException {
        return FileUtils.writeLines(list, file, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset) throws InstrumentException {
        return FileUtils.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset) throws InstrumentException {
        return FileUtils.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset) throws InstrumentException {
        return FileUtils.writeLines(list, file, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset) throws InstrumentException {
        return FileUtils.writeLines(list, file, charset, false);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, File file) throws InstrumentException {
        return FileUtils.appendLines(list, file, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, String path) throws InstrumentException {
        return FileUtils.appendLines(list, path, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static <T> File appendLines(Collection<T> list, String path, String charset) throws InstrumentException {
        return FileUtils.writeLines(list, path, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file, String charset) throws InstrumentException {
        return FileUtils.writeLines(list, file, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, String path, Charset charset) throws InstrumentException {
        return FileUtils.writeLines(list, path, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file, Charset charset) throws InstrumentException {
        return FileUtils.writeLines(list, file, charset, true);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws InstrumentException {
        return FileUtils.writeLines(list, FileUtils.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset, boolean isAppend) throws InstrumentException {
        return FileUtils.writeLines(list, FileUtils.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, CharsetUtils.charset(charset)).writeLines(list, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, charset).writeLines(list, isAppend);
    }

    public static File writeUtf8Map(Map<?, ?> map, File file, String kvSeparator, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, org.aoju.bus.core.consts.Charset.UTF_8).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeMap(Map<?, ?> map, File file, Charset charset, String kvSeparator, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, charset).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeBytes(byte[] data, String path) throws InstrumentException {
        return FileUtils.writeBytes(data, FileUtils.touch(path));
    }

    public static File writeBytes(byte[] data, File dest) throws InstrumentException {
        return FileUtils.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean isAppend) throws InstrumentException {
        return FileWriter.create(dest).write(data, off, len, isAppend);
    }

    public static File writeFromStream(InputStream in, File dest) throws InstrumentException {
        return FileWriter.create(dest).writeFromStream(in);
    }

    public static File writeFromStream(InputStream in, String fullFilePath) throws InstrumentException {
        return FileUtils.writeFromStream(in, FileUtils.touch(fullFilePath));
    }

    public static File writeToStream(File file, OutputStream out) throws InstrumentException {
        return FileReader.create(file).writeToStream(out);
    }

    public static void writeToStream(String fullFilePath, OutputStream out) throws InstrumentException {
        FileUtils.writeToStream(FileUtils.touch(fullFilePath), out);
    }

    public static String readableFileSize(File file) {
        return FileUtils.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static File convertCharset(File file, Charset srcCharset, Charset destCharset) {
        return CharsetUtils.convert(file, srcCharset, destCharset);
    }

    public static File convertLineSeparator(File file, Charset charset, LineSeparator lineSeparator) {
        List<String> lines = FileUtils.readLines(file, charset);
        return FileWriter.create(file, charset).writeLines(lines, lineSeparator, false);
    }

    public static String cleanInvalid(String fileName) {
        return StringUtils.isBlank(fileName) ? fileName : PatternUtils.delAll(FILE_NAME_INVALID_PATTERN_WIN, fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return !StringUtils.isBlank(fileName) && PatternUtils.contains(FILE_NAME_INVALID_PATTERN_WIN, fileName);
    }

    public static long checksumCRC32(File file) throws InstrumentException {
        return FileUtils.checksum(file, new CRC32()).getValue();
    }

    public static Checksum checksum(File file, Checksum checksum) throws InstrumentException {
        Assert.notNull(file, "File is null !", new Object[0]);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            return IoUtils.checksum(new FileInputStream(file), checksum);
        }
        catch (FileNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static File getWebRoot() {
        String classPath = ClassUtils.getClassPath();
        if (StringUtils.isNotBlank(classPath)) {
            return FileUtils.getParent(FileUtils.file(classPath), 2);
        }
        return null;
    }

    public static String getParent(String filePath, int level) {
        File parent = FileUtils.getParent(FileUtils.file(filePath), level);
        try {
            return null == parent ? null : parent.getCanonicalPath();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileUtils.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file) {
            String canonicalPath;
            String parentCanonicalPath;
            try {
                parentCanonicalPath = parentFile.getCanonicalPath();
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
            if (!canonicalPath.startsWith(parentCanonicalPath)) {
                throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
            }
        }
        return file;
    }

    public static String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }
}

