/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;

public class RuntimeUtils {
    public static String execForStr(String ... cmds) throws InstrumentException {
        return RuntimeUtils.execForStr(CharsetUtils.systemCharset(), cmds);
    }

    public static String execForStr(Charset charset, String ... cmds) throws InstrumentException {
        return RuntimeUtils.getResult(RuntimeUtils.exec(cmds), charset);
    }

    public static List<String> execForLines(String ... cmds) throws InstrumentException {
        return RuntimeUtils.execForLines(CharsetUtils.systemCharset(), cmds);
    }

    public static List<String> execForLines(Charset charset, String ... cmds) throws InstrumentException {
        return RuntimeUtils.getResultLines(RuntimeUtils.exec(cmds), charset);
    }

    public static Process exec(String ... cmds) {
        Process process;
        if (ArrayUtils.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StringUtils.isBlank(cmd)) {
                throw new NullPointerException("Command is empty !");
            }
            cmds = StringUtils.splitToArray(cmd, 32);
        }
        try {
            process = new ProcessBuilder(cmds).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return process;
    }

    public static Process exec(String[] envp, String ... cmds) {
        return RuntimeUtils.exec(envp, null, cmds);
    }

    public static Process exec(String[] envp, File dir, String ... cmds) {
        if (ArrayUtils.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StringUtils.isBlank(cmd)) {
                throw new NullPointerException("Command is empty !");
            }
            cmds = StringUtils.splitToArray(cmd, 32);
        }
        try {
            return Runtime.getRuntime().exec(cmds, envp, dir);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static List<String> getResultLines(Process process) {
        return RuntimeUtils.getResultLines(process, CharsetUtils.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResultLines(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            List list = IoUtils.readLines(in, charset, new ArrayList());
            return list;
        }
        finally {
            IoUtils.close(in);
            RuntimeUtils.destroy(process);
        }
    }

    public static String getResult(Process process) {
        return RuntimeUtils.getResult(process, CharsetUtils.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            String string = IoUtils.read(in, charset);
            return string;
        }
        finally {
            IoUtils.close(in);
            RuntimeUtils.destroy(process);
        }
    }

    public static String getErrorResult(Process process) {
        return RuntimeUtils.getErrorResult(process, CharsetUtils.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorResult(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getErrorStream();
            String string = IoUtils.read(in, charset);
            return string;
        }
        finally {
            IoUtils.close(in);
            RuntimeUtils.destroy(process);
        }
    }

    public static void destroy(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(hook instanceof Thread ? (Thread)hook : new Thread(hook));
    }
}

