/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.aoju.bus.core.beans.BeanDesc;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.beans.copier.provider.BeanValueProvider;
import org.aoju.bus.core.beans.copier.provider.MapValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.copier.Copier;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TypeUtils;

public class BeanCopier<T>
implements Copier<T> {
    private Object source;
    private T dest;
    private CopyOptions copyOptions;

    public BeanCopier(Object source, T dest, CopyOptions copyOptions) {
        this.source = source;
        this.dest = dest;
        this.copyOptions = copyOptions;
    }

    public static <T> BeanCopier<T> create(Object source, T dest, CopyOptions copyOptions) {
        return new BeanCopier<T>(source, dest, copyOptions);
    }

    private static String mappingKey(Map<String, String> mapping, String fieldName) {
        if (MapUtils.isEmpty(mapping)) {
            return fieldName;
        }
        return ObjectUtils.defaultIfNull(mapping.get(fieldName), fieldName);
    }

    @Override
    public T copy() {
        if (null != this.source) {
            if (this.source instanceof ValueProvider) {
                this.valueProviderToBean((ValueProvider)this.source, this.dest);
            } else if (this.source instanceof Map) {
                if (this.dest instanceof Map) {
                    this.mapToMap((Map)this.source, (Map)this.dest);
                } else {
                    this.mapToBean((Map)this.source, this.dest);
                }
            } else if (this.dest instanceof Map) {
                this.beanToMap(this.source, (Map)this.dest);
            } else {
                this.beanToBean(this.source, this.dest);
            }
        }
        return this.dest;
    }

    private void beanToBean(Object providerBean, Object destBean) {
        this.valueProviderToBean(new BeanValueProvider(providerBean, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), destBean);
    }

    private void mapToBean(Map<?, ?> map, Object bean) {
        this.valueProviderToBean(new MapValueProvider(map, this.copyOptions.ignoreCase), bean);
    }

    private void mapToMap(Map source, Map dest) {
        if (null != dest && null != source) {
            dest.putAll(source);
        }
    }

    private void beanToMap(Object bean, Map targetMap) {
        Collection<BeanDesc.PropDesc> props = BeanUtils.getBeanDesc(bean.getClass()).getProps();
        HashSet<String> ignoreSet = null != this.copyOptions.ignoreProperties ? CollUtils.newHashSet(this.copyOptions.ignoreProperties) : null;
        CopyOptions copyOptions = this.copyOptions;
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) continue;
                throw new InstrumentException("Get value of [{}] error!", prop.getFieldName());
            }
            if (CollUtils.contains(ignoreSet, key) || null == value && copyOptions.ignoreNullValue || bean.equals(value)) continue;
            targetMap.put(BeanCopier.mappingKey(copyOptions.fieldMapping, key), value);
        }
    }

    private void valueProviderToBean(ValueProvider<String> valueProvider, Object bean) {
        if (null == valueProvider) {
            return;
        }
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = bean.getClass();
        if (copyOptions.editable != null) {
            if (!copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StringUtils.format("Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        HashSet<String> ignoreSet = null != copyOptions.ignoreProperties ? CollUtils.newHashSet(copyOptions.ignoreProperties) : null;
        Map<String, String> fieldReverseMapping = copyOptions.getReversedMapping();
        Collection<BeanDesc.PropDesc> props = BeanUtils.getBeanDesc(actualEditable).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            Method setterMethod;
            String providerKey;
            String fieldName = prop.getFieldName();
            if (CollUtils.contains(ignoreSet, fieldName) || !valueProvider.containsKey(providerKey = BeanCopier.mappingKey(fieldReverseMapping, fieldName)) || null == (setterMethod = prop.getSetter()) || null == (value = valueProvider.value(providerKey, TypeUtils.getFirstParamType(setterMethod))) && copyOptions.ignoreNullValue || bean.equals(value)) continue;
            try {
                Class<?> propClass = prop.getFieldClass();
                if (!propClass.isInstance(value) && null == (value = Convert.convert(propClass, value)) && copyOptions.ignoreNullValue) continue;
                setterMethod.invoke(bean, value);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) continue;
                throw new InstrumentException("Inject [{}] error!", prop.getFieldName());
            }
        }
    }
}

