/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.aoju.bus.core.consts.RegEx;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Matcher;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.PatternUtils;
import org.aoju.bus.core.utils.StringUtils;

public class Validator {
    public static boolean isNull(Object value) {
        return null == value;
    }

    public static boolean isNotNull(Object value) {
        return null != value;
    }

    public static <T> T validateNotNull(T value, String errorMsgTemplate, Object ... params) throws InstrumentException {
        if (Validator.isNull(value)) {
            throw new InstrumentException(errorMsgTemplate, params);
        }
        return value;
    }

    public static boolean isEmpty(Object value) {
        return null == value || value instanceof String && StringUtils.isEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        return false == Validator.isEmpty(value);
    }

    public static void validateNotEmpty(Object value, String errorMsg) throws InstrumentException {
        if (Validator.isEmpty(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean equal(Object t1, Object t2) {
        return ObjectUtils.equal(t1, t2);
    }

    public static void validateEqual(Object t1, Object t2, String errorMsg) throws InstrumentException {
        if (!Validator.equal(t1, t2)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static void validateNotEqual(Object t1, Object t2, String errorMsg) throws InstrumentException {
        if (Validator.equal(t1, t2)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static void validateNotEmptyAndEqual(Object t1, Object t2, String errorMsg) throws InstrumentException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateEqual(t1, t2, errorMsg);
    }

    public static void validateNotEmptyAndNotEqual(Object t1, Object t2, String errorMsg) throws InstrumentException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateNotEqual(t1, t2, errorMsg);
    }

    public static boolean isMactchRegex(String regex, String value) {
        return PatternUtils.isMatch(regex, value);
    }

    public static void validateMatchRegex(String regex, String value, String errorMsg) throws InstrumentException {
        if (!Validator.isMactchRegex(regex, value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isMactchRegex(Pattern pattern, String value) {
        return PatternUtils.isMatch(pattern, value);
    }

    public static boolean isGeneral(String value) {
        return Validator.isMactchRegex(RegEx.GENERAL, value);
    }

    public static void validateGeneral(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isGeneral(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min, int max) {
        String reg = "^\\w{" + min + "," + max + "}$";
        if (min < 0) {
            min = 0;
        }
        if (max <= 0) {
            reg = "^\\w{" + min + ",}$";
        }
        return Validator.isMactchRegex(reg, value);
    }

    public static void validateGeneral(String value, int min, int max, String errorMsg) throws InstrumentException {
        if (!Validator.isGeneral(value, min, max)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min) {
        return Validator.isGeneral(value, min, 0);
    }

    public static void validateGeneral(String value, int min, String errorMsg) throws InstrumentException {
        Validator.validateGeneral(value, min, 0, errorMsg);
    }

    public static boolean isLetter(String value) {
        return StringUtils.isAllCharMatch(value, new Matcher<Character>(){

            @Override
            public boolean match(Character t) {
                return Character.isLetter(t.charValue());
            }
        });
    }

    public static void validateLetter(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isLetter(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isUpperCase(String value) {
        return StringUtils.isAllCharMatch(value, new Matcher<Character>(){

            @Override
            public boolean match(Character t) {
                return Character.isUpperCase(t.charValue());
            }
        });
    }

    public static void validateUpperCase(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isUpperCase(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isLowerCase(String value) {
        return StringUtils.isAllCharMatch(value, new Matcher<Character>(){

            @Override
            public boolean match(Character t) {
                return Character.isLowerCase(t.charValue());
            }
        });
    }

    public static void validateLowerCase(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isLowerCase(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isNumber(String value) {
        return NumberUtils.isNumber(value);
    }

    public static void validateNumber(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isNumber(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isWord(String value) {
        return Validator.isMactchRegex(RegEx.WORD, value);
    }

    public static void validateWord(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isWord(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isMoney(String value) {
        return Validator.isMactchRegex(RegEx.MONEY, value);
    }

    public static void validateMoney(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isMoney(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isZipCode(String value) {
        return Validator.isMactchRegex(RegEx.ZIP_CODE, value);
    }

    public static void validateZipCode(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isZipCode(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isEmail(String value) {
        return Validator.isMactchRegex(RegEx.EMAIL, value);
    }

    public static void validateEmail(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isEmail(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isMobile(String value) {
        return Validator.isMactchRegex(RegEx.MOBILE, value);
    }

    public static void validateMobile(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isMobile(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isCitizenId(String value) {
        return Validator.isMactchRegex(RegEx.CITIZEN_ID, value);
    }

    public static void validateCitizenIdNumber(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isCitizenId(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isBirthday(int year, int month, int day) {
        int thisYear = DateUtils.thisYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            return false;
        }
        if (month == 2) {
            return day <= 29 && (day != 29 || false != DateUtils.isLeapYear(year));
        }
        return true;
    }

    public static boolean isBirthday(String value) {
        java.util.regex.Matcher matcher;
        if (Validator.isMactchRegex(RegEx.BIRTHDAY, value) && (matcher = RegEx.BIRTHDAY.matcher(value)).find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday(year, month, day);
        }
        return false;
    }

    public static void validateBirthday(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isBirthday(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isIpv4(String value) {
        return Validator.isMactchRegex(RegEx.IPV4, value);
    }

    public static void validateIpv4(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isIpv4(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isMac(String value) {
        return Validator.isMactchRegex(RegEx.MAC_ADDRESS, value);
    }

    public static void validateMac(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isMac(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isPlateNumber(String value) {
        return Validator.isMactchRegex(RegEx.PLATE_NUMBER, value);
    }

    public static void validatePlateNumber(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isPlateNumber(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isUrl(String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static void validateUrl(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isUrl(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isChinese(String value) {
        return Validator.isMactchRegex("^[\u4e00-\u9fff]+$", value);
    }

    public static void validateChinese(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isChinese(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isGeneralWithChinese(String value) {
        return Validator.isMactchRegex(RegEx.GENERAL_WITH_CHINESE, value);
    }

    public static void validateGeneralWithChinese(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isGeneralWithChinese(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isUUID(String value) {
        return Validator.isMactchRegex(RegEx.UUID, value) || Validator.isMactchRegex(RegEx.UUID_SIMPLE, value);
    }

    public static void validateUUID(String value, String errorMsg) throws InstrumentException {
        if (!Validator.isUUID(value)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isBetween(Number value, Number min, Number max) {
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double doubleValue = value.doubleValue();
        return doubleValue >= min.doubleValue() && doubleValue <= max.doubleValue();
    }

    public static void validateBetween(Number value, Number min, Number max, String errorMsg) throws InstrumentException {
        if (!Validator.isBetween(value, min, max)) {
            throw new InstrumentException(errorMsg);
        }
    }

    public static boolean isHex(CharSequence value) {
        return Validator.isMactchRegex(RegEx.HEX, value.toString());
    }
}

