/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.consts;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;

public final class FileType {
    public static final String CLASS = ".class";
    public static final String JAR = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";
    public static final Map<String, String> PICS = new HashMap<String, String>(){
        {
            this.put(".jpe", "image/jpeg");
            this.put(".jpeg", "image/jpeg");
            this.put(".jpg", "image/jpeg");
            this.put(".bmp", "image/bmp");
            this.put(".png", "image/png");
            this.put(".gif", "image/gif");
            this.put(".jfif", "image/pjpeg");
            this.put(".dib", "image/bmp");
            this.put(".pnz", "image/png");
            this.put(".art", "image/x-jg");
            this.put(".cmx", "image/x-cmx");
            this.put(".ico", "image/x-icon");
            this.put(".ppm", "image/x-portable-pixmap");
            this.put(".mac", "image/x-macpaint");
            this.put(".pbm", "image/x-portable-bitmap");
            this.put(".pgm", "image/x-portable-graymap");
            this.put(".pnm", "image/x-portable-anymap");
            this.put(".pnt", "image/x-macpaint");
            this.put(".pntg", "image/x-macpaint");
            this.put(".qti", "image/x-quicktime");
            this.put(".qtif", "image/x-quicktime");
            this.put(".rgb", "image/x-rgb");
            this.put(".xwd", "image/x-xwindowdump");
            this.put(".ras", "image/x-cmu-raster");
            this.put(".xbm", "image/x-xbitmap");
            this.put(".xpm", "image/x-xpixmap");
            this.put(".cod", "image/cis-cod");
            this.put(".ief", "image/ief");
            this.put(".pct", "image/pict");
            this.put(".pic", "image/pict");
            this.put(".pict", "image/pict");
            this.put(".rf", "image/vnd.rn-realflash");
            this.put(".wbmp", "image/vnd.wap.wbmp");
            this.put(".wdp", "image/vnd.ms-photo");
            this.put(".tif", "image/tiff");
            this.put(".tiff", "image/tiff");
        }
    };
    public static final Map<String, String> DOCS = new HashMap<String, String>(){
        {
            this.put(".txt", "text/plain");
            this.put(".css", "text/css");
            this.put(".htm", "text/html");
            this.put(".html", "text/html");
            this.put(".shtml", "text/html");
            this.put(".wsdl", "text/xml");
            this.put(".xml", "text/xml");
            this.put(".pdf", "application/pdf");
            this.put(".ppt", "application/vnd.ms-powerpoint");
            this.put(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            this.put(".doc", "application/msword");
            this.put(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            this.put(".xlm", "application/vnd.ms-excel");
            this.put(".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.put(".one", "application/onenote");
            this.put(".accdb", "application/msaccess");
            this.put(".vsd", "application/vnd.visio");
            this.put(".323", "text/h323");
            this.put(".rqy", "text/x-ms-rqy");
            this.put(".rtx", "text/richtext");
            this.put(".rc", "text/plain");
            this.put(".XOML", "text/plain");
            this.put(".sln", "text/plain");
            this.put(".rgs", "text/plain");
            this.put(".pkgdef", "text/plain");
            this.put(".pkgundef", "text/plain");
            this.put(".sol", "text/plain");
            this.put(".sor", "text/plain");
            this.put(".srf", "text/plain");
            this.put(".xdr", "text/plain");
            this.put(".rc2", "text/plain");
            this.put(".rct", "text/plain");
            this.put(".s", "text/plain");
            this.put(".asm", "text/plain");
            this.put(".c", "text/plain");
            this.put(".cc", "text/plain");
            this.put(".cd", "text/plain");
            this.put(".def", "text/plain");
            this.put(".cxx", "text/plain");
            this.put(".cnf", "text/plain");
            this.put(".cpp", "text/plain");
            this.put(".cs", "text/plain");
            this.put(".csdproj", "text/plain");
            this.put(".csproj", "text/plain");
            this.put(".dbproj", "text/plain");
            this.put(".bas", "text/plain");
            this.put(".dsw", "text/plain");
            this.put(".inc", "text/plain");
            this.put(".hxx", "text/plain");
            this.put(".i", "text/plain");
            this.put(".idl", "text/plain");
            this.put(".inl", "text/plain");
            this.put(".lst", "text/plain");
            this.put(".jsxbin", "text/plain");
            this.put(".mak", "text/plain");
            this.put(".map", "text/plain");
            this.put(".h", "text/plain");
            this.put(".hpp", "text/plain");
            this.put(".ipproj", "text/plain");
            this.put(".mk", "text/plain");
            this.put(".odh", "text/plain");
            this.put(".odl", "text/plain");
            this.put(".tsv", "text/tab-separated-values");
            this.put(".uls", "text/iuls");
            this.put(".user", "text/plain");
            this.put(".tlh", "text/plain");
            this.put(".tli", "text/plain");
            this.put(".vb", "text/plain");
            this.put(".vbdproj", "text/plain");
            this.put(".vbproj", "text/plain");
            this.put(".vcs", "text/plain");
            this.put(".vddproj", "text/plain");
            this.put(".vdp", "text/plain");
            this.put(".vdproj", "text/plain");
            this.put(".vspscc", "text/plain");
            this.put(".vsscc", "text/plain");
            this.put(".vssscc", "text/plain");
            this.put(".hxt", "text/html");
            this.put(".vssettings", "text/xml");
            this.put(".vstemplate", "text/xml");
            this.put(".vml", "text/xml");
            this.put(".vsct", "text/xml");
            this.put(".vsixlangpack", "text/xml");
            this.put(".vsixmanifest", "text/xml");
            this.put(".exe.config", "text/xml");
            this.put(".disco", "text/xml");
            this.put(".dll.config", "text/xml");
            this.put(".AddIn", "text/xml");
            this.put(".dtd", "text/xml");
            this.put(".dtsConfig", "text/xml");
            this.put(".mno", "text/xml");
            this.put(".xrm-ms", "text/xml");
            this.put(".xsd", "text/xml");
            this.put(".xsf", "text/xml");
            this.put(".xsl", "text/xml");
            this.put(".xslt", "text/xml");
            this.put(".SSISDeploymentManifest", "text/xml");
            this.put(".iqy", "text/x-ms-iqy");
            this.put(".contact", "text/x-ms-contact");
            this.put(".etx", "text/x-setext");
            this.put(".hdml", "text/x-hdml");
            this.put(".htc", "text/x-component");
            this.put(".group", "text/x-ms-group");
            this.put(".vcf", "text/x-vcard");
            this.put(".odc", "text/x-ms-odc");
            this.put(".qht", "text/x-html-insertion");
            this.put(".qhtm", "text/x-html-insertion");
            this.put(".wml", "text/vnd.wap.wml");
            this.put(".wmls", "text/vnd.wap.wmlscript");
            this.put(".vbs", "text/vbscript");
            this.put(".jsx", "text/jscript");
            this.put(".sct", "text/scriptlet");
            this.put(".csv", "text/csv");
            this.put(".323", "text/h323");
            this.put(".dlm", "text/dlm");
            this.put(".htt", "text/webviewhtml");
            this.put(".wsc", "text/scriptlet");
            this.put(".sgml", "text/sgml");
            this.put(".pot", "application/vnd.ms-powerpoint");
            this.put(".ppa", "application/vnd.ms-powerpoint");
            this.put(".pwz", "application/vnd.ms-powerpoint");
            this.put(".pps", "application/vnd.ms-powerpoint");
            this.put(".sldm", "application/vnd.ms-powerpoint.slide.macroEnabled.12");
            this.put(".ppam", "application/vnd.ms-powerpoint.addin.macroEnabled.12");
            this.put(".potm", "application/vnd.ms-powerpoint.template.macroEnabled.12");
            this.put(".ppsm", "application/vnd.ms-powerpoint.slideshow.macroEnabled.12");
            this.put(".pptm", "application/vnd.ms-powerpoint.presentation.macroEnabled.12");
            this.put(".potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
            this.put(".ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
            this.put(".wbk", "application/msword");
            this.put(".wiz", "application/msword");
            this.put(".dot", "application/msword");
            this.put(".docm", "application/vnd.ms-word.document.macroEnabled.12");
            this.put(".dotm", "application/vnd.ms-word.template.macroEnabled.12");
            this.put(".dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
            this.put(".xla", "application/vnd.ms-excel");
            this.put(".xlc", "application/vnd.ms-excel");
            this.put(".xld", "application/vnd.ms-excel");
            this.put(".xlk", "application/vnd.ms-excel");
            this.put(".xll", "application/vnd.ms-excel");
            this.put(".xls", "application/vnd.ms-excel");
            this.put(".xlt", "application/vnd.ms-excel");
            this.put(".xlw", "application/vnd.ms-excel");
            this.put(".slk", "application/vnd.ms-excel");
            this.put(".xlam", "application/vnd.ms-excel.addin.macroEnabled.12");
            this.put(".xlsm", "application/vnd.ms-excel.sheet.macroEnabled.12");
            this.put(".xltm", "application/vnd.ms-excel.template.macroEnabled.12");
            this.put(".xlsb", "application/vnd.ms-excel.sheet.binary.macroEnabled.12");
            this.put(".xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
            this.put(".accde", "application/msaccess");
            this.put(".accdt", "application/msaccess");
            this.put(".adp", "application/msaccess");
            this.put(".mda", "application/msaccess");
            this.put(".mde", "application/msaccess");
            this.put(".accda", "application/msaccess.addin");
            this.put(".accdc", "application/msaccess.cab");
            this.put(".accdr", "application/msaccess.runtime");
            this.put(".accdw", "application/msaccess.webapplication");
            this.put(".accft", "application/msaccess.ftemplate");
            this.put(".ade", "application/msaccess");
            this.put(".thmx", "application/vnd.ms-officetheme");
            this.put(".vdx", "application/vnd.ms-visio.viewer");
            this.put(".vss", "application/vnd.visio");
            this.put(".vst", "application/vnd.visio");
            this.put(".vsw", "application/vnd.visio");
            this.put(".vsx", "application/vnd.visio");
            this.put(".vtx", "application/vnd.visio");
            this.put(".onea", "application/onenote");
            this.put(".onepkg", "application/onenote");
            this.put(".onetmp", "application/onenote");
            this.put(".onetoc", "application/onenote");
            this.put(".onetoc2", "application/onenote");
            this.put(".pko", "application/vnd.ms-pki.pko");
            this.put(".cat", "application/vnd.ms-pki.seccat");
            this.put(".sst", "application/vnd.ms-pki.certstore");
            this.put(".stl", "application/vnd.ms-pki.stl");
            this.put(".mpf", "application/vnd.ms-mediapackage");
            this.put(".mpp", "application/vnd.ms-project");
            this.put(".wpl", "application/vnd.ms-wpl");
            this.put(".wks", "application/vnd.ms-works");
            this.put(".wps", "application/vnd.ms-works");
            this.put(".wcm", "application/vnd.ms-works");
            this.put(".wdb", "application/vnd.ms-works");
            this.put(".calx", "application/vnd.ms-office.calx");
            this.put(".xps", "application/vnd.ms-xpsdocument");
            this.put(".odp", "application/vnd.oasis.opendocument.presentation");
            this.put(".odt", "application/vnd.oasis.opendocument.text");
            this.put(".rm", "application/vnd.rn-realmedia");
            this.put(".rmp", "application/vnd.rn-rn_music_package");
            this.put(".sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
            this.put(".air", "application/vnd.adobe.air-application-installer-package+zip");
            this.put(".wmlsc", "application/vnd.wap.wmlscriptc");
            this.put(".wmlc", "application/vnd.wap.wmlc");
            this.put(".m13", "application/x-msmediaview");
            this.put(".m14", "application/x-msmediaview");
            this.put(".wmf", "application/x-msmetafile");
            this.put(".wri", "application/x-mswrite");
            this.put(".mdb", "application/x-msaccess");
            this.put(".wmd", "application/x-ms-wmd");
            this.put(".wmz", "application/x-ms-wmz");
        }
    };
    public static final Map<String, String> ZIPDOCS = new HashMap<String, String>(){
        {
            this.put(".7z", "application/x-7z-compressed");
            this.put(".z", "application/x-compress");
            this.put(".zip", "application/x-zip-compressed");
            this.put(".tgz", "application/x-compressed");
            this.put(FileType.JAR, "application/java-archive");
            this.put(".rar", "application/octet-stream");
            this.put(".war", "application/octet-stream");
            this.put(".tar", "application/x-tar");
        }
    };
    public static final Map<String, String> VIDEOS = new HashMap<String, String>(){
        {
            this.put(".flv", "video/x-flv");
            this.put(".3gp", "video/3gpp");
            this.put(".avi", "video/x-msvideo");
            this.put(".mp4", "video/mp4");
            this.put(".3g2", "video/3gpp2");
            this.put(".3gp2", "video/3gpp2");
            this.put(".3gpp", "video/3gpp");
            this.put(".asf", "video/x-ms-asf");
            this.put(".asr", "video/x-ms-asf");
            this.put(".asx", "video/x-ms-asf");
            this.put(".dif", "video/x-dv");
            this.put(".mod", "video/mpeg");
            this.put(".mov", "video/quicktime");
            this.put(".movie", "video/x-sgi-movie");
            this.put(".mp2", "video/mpeg");
            this.put(".mp2v", "video/mpeg");
            this.put(".dv", "video/x-dv");
            this.put(".IVF", "video/x-ivf");
            this.put(".lsf", "video/x-la-asf");
            this.put(".lsx", "video/x-la-asf");
            this.put(".m1v", "video/mpeg");
            this.put(".m2t", "video/vnd.dlna.mpeg-tts");
            this.put(".m2ts", "video/vnd.dlna.mpeg-tts");
            this.put(".m2v", "video/mpeg");
            this.put(".m4v", "video/x-m4v");
            this.put(".mp4v", "video/mp4");
            this.put(".mpa", "video/mpeg");
            this.put(".mpe", "video/mpeg");
            this.put(".mpeg", "video/mpeg");
            this.put(".wm", "video/x-ms-wm");
            this.put(".mpg", "video/mpeg");
            this.put(".mpv2", "video/mpeg");
            this.put(".mqv", "video/quicktime");
            this.put(".nsc", "video/x-ms-asf");
            this.put(".qt", "video/quicktime");
            this.put(".ts", "video/vnd.dlna.mpeg-tts");
            this.put(".vbk", "video/mpeg");
            this.put(".wmp", "video/x-ms-wmp");
            this.put(".wmv", "video/x-ms-wmv");
            this.put(".wmx", "video/x-ms-wmx");
            this.put(".wvx", "video/x-ms-wvx");
            this.put(".mts", "video/vnd.dlna.mpeg-tts");
            this.put(".tts", "video/vnd.dlna.mpeg-tts");
        }
    };
    public static final Map<String, String> AUDIOS = new HashMap<String, String>(){
        {
            this.put(".mp3", "audio/mpeg");
            this.put(".wma", "audio/x-ms-wma");
            this.put(".aa", "audio/audible");
            this.put(".AAC", "audio/aac");
            this.put(".aax", "audio/vnd.audible.aax");
            this.put(".ac3", "audio/ac3");
            this.put(".ADT", "audio/vnd.dlna.adts");
            this.put(".ADTS", "audio/aac");
            this.put(".aif", "audio/x-aiff");
            this.put(".aifc", "audio/aiff");
            this.put(".aiff", "audio/aiff");
            this.put(".cdda", "audio/aiff");
            this.put(".au", "audio/basic");
            this.put(".m3u", "audio/x-mpegurl");
            this.put(".m3u8", "audio/x-mpegurl");
            this.put(".m4a", "audio/m4a");
            this.put(".m4b", "audio/m4b");
            this.put(".m4p", "audio/m4p");
            this.put(".m4r", "audio/x-m4r");
            this.put(".caf", "audio/x-caf");
            this.put(".gsm", "audio/x-gsm");
            this.put(".mid", "audio/mid");
            this.put(".midi", "audio/mid");
            this.put(".pls", "audio/scpls");
            this.put(".ra", "audio/x-pn-realaudio");
            this.put(".ram", "audio/x-pn-realaudio");
            this.put(".rmi", "audio/mid");
            this.put(".rpm", "audio/x-pn-realaudio-plugin");
            this.put(".sd2", "audio/x-sd2");
            this.put(".smd", "audio/x-smd");
            this.put(".smx", "audio/x-smd");
            this.put(".smz", "audio/x-smd");
            this.put(".snd", "audio/basic");
            this.put(".wav", "audio/wav");
            this.put(".wave", "audio/wav");
            this.put(".wax", "audio/x-ms-wax");
        }
    };
    public static final Map<String, String> OTHER = new HashMap<String, String>(){
        {
            this.put(".asa", "application/xml");
            this.put(".asax", "application/xml");
            this.put(".ascx", "application/xml");
            this.put(".ashx", "application/xml");
            this.put(".asmx", "application/xml");
            this.put(".aspx", "application/xml");
            this.put(".config", "application/xml");
            this.put(".coverage", "application/xml");
            this.put(".datasource", "application/xml");
            this.put(".dgml", "application/xml");
            this.put(".generictest", "application/xml");
            this.put(".hxa", "application/xml");
            this.put(".hxc", "application/xml");
            this.put(".hxe", "application/xml");
            this.put(".hxf", "application/xml");
            this.put(".hxk", "application/xml");
            this.put(".svc", "application/xml");
            this.put(".rdlc", "application/xml");
            this.put(".resx", "application/xml");
            this.put(".ruleset", "application/xml");
            this.put(".settings", "application/xml");
            this.put(".snippet", "application/xml");
            this.put(".testrunconfig", "application/xml");
            this.put(".testsettings", "application/xml");
            this.put(".xss", "application/xml");
            this.put(".xsc", "application/xml");
            this.put(".hxv", "application/xml");
            this.put(".loadtest", "application/xml");
            this.put(".trx", "application/xml");
            this.put(".psess", "application/xml");
            this.put(".mtx", "application/xml");
            this.put(".master", "application/xml");
            this.put(".orderedtest", "application/xml");
            this.put(".sitemap", "application/xml");
            this.put(".skin", "application/xml");
            this.put(".vscontent", "application/xml");
            this.put(".vsmdi", "application/xml");
            this.put(".webtest", "application/xml");
            this.put(".wiq", "application/xml");
            this.put(".xmta", "application/xml");
            this.put(".filters", "Application/xml");
            this.put(".vcproj", "Application/xml");
            this.put(".vcxproj", "Application/xml");
            this.put(".thn", "application/octet-stream");
            this.put(".toc", "application/octet-stream");
            this.put(".ttf", "application/octet-stream");
            this.put(".u32", "application/octet-stream");
            this.put(".xsn", "application/octet-stream");
            this.put(".xtp", "application/octet-stream");
            this.put(".aaf", "application/octet-stream");
            this.put(".aca", "application/octet-stream");
            this.put(".afm", "application/octet-stream");
            this.put(".asd", "application/octet-stream");
            this.put(".asi", "application/octet-stream");
            this.put(".cab", "application/octet-stream");
            this.put(".bin", "application/octet-stream");
            this.put(".chm", "application/octet-stream");
            this.put(".cur", "application/octet-stream");
            this.put(".dat", "application/octet-stream");
            this.put(".deploy", "application/octet-stream");
            this.put(".dwp", "application/octet-stream");
            this.put(".dsp", "application/octet-stream");
            this.put(".emz", "application/octet-stream");
            this.put(".eot", "application/octet-stream");
            this.put(".exe", "application/octet-stream");
            this.put(".hxd", "application/octet-stream");
            this.put(".hxh", "application/octet-stream");
            this.put(".hxi", "application/octet-stream");
            this.put(".hxq", "application/octet-stream");
            this.put(".hxr", "application/octet-stream");
            this.put(".hxs", "application/octet-stream");
            this.put(".hxw", "application/octet-stream");
            this.put(".ics", "application/octet-stream");
            this.put(".hhk", "application/octet-stream");
            this.put(".hhp", "application/octet-stream");
            this.put(".inf", "application/octet-stream");
            this.put(".fla", "application/octet-stream");
            this.put(".java", "application/octet-stream");
            this.put(".jpb", "application/octet-stream");
            this.put(".mdp", "application/octet-stream");
            this.put(".mix", "application/octet-stream");
            this.put(".msi", "application/octet-stream");
            this.put(".mso", "application/octet-stream");
            this.put(".ocx", "application/octet-stream");
            this.put(".pcx", "application/octet-stream");
            this.put(".pcz", "application/octet-stream");
            this.put(".pfb", "application/octet-stream");
            this.put(".pfm", "application/octet-stream");
            this.put(".lzh", "application/octet-stream");
            this.put(".lpk", "application/octet-stream");
            this.put(".qxd", "application/octet-stream");
            this.put(".prm", "application/octet-stream");
            this.put(".prx", "application/octet-stream");
            this.put(".psd", "application/octet-stream");
            this.put(".psm", "application/octet-stream");
            this.put(".psp", "application/octet-stream");
            this.put(".sea", "application/octet-stream");
            this.put(".smi", "application/octet-stream");
            this.put(".snp", "application/octet-stream");
            this.put(".acx", "application/internet-property-stream");
            this.put(".ai", "application/postscript");
            this.put(".atom", "application/atom+xml");
            this.put(".axs", "application/olescript");
            this.put(".ustar", "application/x-ustar");
            this.put(".bcpio", "application/x-bcpio");
            this.put(".xhtml", "application/xhtml+xml");
            this.put(".crl", "application/pkix-crl");
            this.put(".amc", "application/x-mpeg");
            this.put(".cdf", "application/x-cdf");
            this.put(".cer", "application/x-x509-ca-cert");
            this.put(FileType.CLASS, "application/x-java-applet");
            this.put(".clp", "application/x-msclip");
            this.put(".application", "application/x-ms-application");
            this.put(".adobebridge", "application/x-bridge-url");
            this.put(".cpio", "application/x-cpio");
            this.put(".crd", "application/x-mscardfile");
            this.put(".crt", "application/x-x509-ca-cert");
            this.put(".der", "application/x-x509-ca-cert");
            this.put(".csh", "application/x-csh");
            this.put(".dcr", "application/x-director");
            this.put(".dir", "application/x-director");
            this.put(".dll", "application/x-msdownload");
            this.put(".dvi", "application/x-dvi");
            this.put(".dwf", "drawing/x-dwf");
            this.put(".dxr", "application/x-director");
            this.put(".flr", "x-world/x-vrml");
            this.put(".gtar", "application/x-gtar");
            this.put(".gz", "application/x-gzip");
            this.put(".hdf", "application/x-hdf");
            this.put(".hhc", "application/x-oleobject");
            this.put(".mmf", "application/x-smaf");
            this.put(".mny", "application/x-msmoney");
            this.put(".ms", "application/x-troff-ms");
            this.put(".mvb", "application/x-msmediaview");
            this.put(".mvc", "application/x-miva-compiled");
            this.put(".mxp", "application/x-mmxp");
            this.put(".nc", "application/x-netcdf");
            this.put(".pcast", "application/x-podcast");
            this.put(".ins", "application/x-internet-signup");
            this.put(".jnlp", "application/x-java-jnlp-file");
            this.put(".js", "application/x-javascript");
            this.put(".latex", "application/x-latex");
            this.put(".lit", "application/x-ms-reader");
            this.put(".manifest", "application/x-ms-manifest");
            this.put(".man", "application/x-troff-man");
            this.put(".me", "application/x-troff-me");
            this.put(".mfp", "application/x-shockwave-flash");
            this.put(".pfx", "application/x-pkcs12");
            this.put(".p7r", "application/x-pkcs7-certreqresp");
            this.put(".p12", "application/x-pkcs12");
            this.put(".p7b", "application/x-pkcs7-certificates");
            this.put(".pma", "application/x-perfmon");
            this.put(".pmc", "application/x-perfmon");
            this.put(".pml", "application/x-perfmon");
            this.put(".pmr", "application/x-perfmon");
            this.put(".pmw", "application/x-perfmon");
            this.put(".iii", "application/x-iphone");
            this.put(".ipa", "application/x-itunes-ipa");
            this.put(".ipg", "application/x-itunes-ipg");
            this.put(".ipsw", "application/x-itunes-ipsw");
            this.put(".isp", "application/x-internet-signup");
            this.put(".ite", "application/x-itunes-ite");
            this.put(".itlp", "application/x-itunes-itlp");
            this.put(".itms", "application/x-itunes-itms");
            this.put(".itpc", "application/x-itunes-itpc");
            this.put(".eps", "application/postscript");
            this.put(".etl", "application/etl");
            this.put(".evy", "application/envoy");
            this.put(".fdf", "application/vnd.fdf");
            this.put(".fif", "application/fractals");
            this.put(".fsscript", "application/fsharp-script");
            this.put(".fsx", "application/fsharp-script");
            this.put(".hlp", "application/winhlp");
            this.put(".hqx", "application/mac-binhex40");
            this.put(".hta", "application/hta");
            this.put(".jck", "application/liquidmotion");
            this.put(".jcz", "application/liquidmotion");
            this.put(".library-ms", "application/windows-library+xml");
            this.put(".mht", "message/rfc822");
            this.put(".mhtml", "message/rfc822");
            this.put(".nws", "message/rfc822");
            this.put(".eml", "message/rfc822");
            this.put(".oda", "application/oda");
            this.put(".ods", "application/oleobject");
            this.put(".osdx", "application/opensearchdescription+xml");
            this.put(".p10", "application/pkcs10");
            this.put(".p7c", "application/pkcs7-mime");
            this.put(".p7m", "application/pkcs7-mime");
            this.put(".p7s", "application/pkcs7-signature");
            this.put(".prf", "application/pics-rules");
            this.put(".ps", "application/postscript");
            this.put(".psc1", "application/PowerShell");
            this.put(".pub", "application/x-mspublisher");
            this.put(".qtl", "application/x-quicktimeplayer");
            this.put(".rat", "application/rat-file");
            this.put(".roff", "application/x-troff");
            this.put(".rtf", "application/rtf");
            this.put(".safariextz", "application/x-safari-safariextz");
            this.put(".scd", "application/x-msschedule");
            this.put(".sdp", "application/sdp");
            this.put(".searchConnector-ms", "application/windows-search-connector+xml");
            this.put(".setpay", "application/set-payment-initiation");
            this.put(".setreg", "application/set-registration-initiation");
            this.put(".sgimb", "application/x-sgimb");
            this.put(".sh", "application/x-sh");
            this.put(".shar", "application/x-shar");
            this.put(".sit", "application/x-stuffit");
            this.put(".slupkg-ms", "application/x-ms-license");
            this.put(".spc", "application/x-pkcs7-certificates");
            this.put(".spl", "application/futuresplash");
            this.put(".src", "application/x-wais-source");
            this.put(".ssm", "application/streamingmedia");
            this.put(".sv4cpio", "application/x-sv4cpio");
            this.put(".sv4crc", "application/x-sv4crc");
            this.put(".swf", "application/x-shockwave-flash");
            this.put(".t", "application/x-troff");
            this.put(".tcl", "application/x-tcl");
            this.put(".tex", "application/x-tex");
            this.put(".texi", "application/x-texinfo");
            this.put(".texinfo", "application/x-texinfo");
            this.put(".tr", "application/x-troff");
            this.put(".trm", "application/x-msterminal");
            this.put(".vsi", "application/ms-vsi");
            this.put(".vsix", "application/vsix");
            this.put(".vsto", "application/x-ms-vsto");
            this.put(".webarchive", "application/x-safari-webarchive");
            this.put(".WLMP", "application/wlmoviemaker");
            this.put(".wlpginstall", "application/x-wlpg-detect");
            this.put(".wlpginstall3", "application/x-wlpg3-detect");
            this.put(".x", "application/directx");
            this.put(".xaml", "application/xaml+xml");
            this.put(".xht", "application/xhtml+xml");
            this.put(".xap", "application/x-silverlight-app");
            this.put(".xbap", "application/x-ms-xbap");
            this.put(".xaf", "x-world/x-vrml");
            this.put(".xof", "x-world/x-vrml");
            this.put(".wrl", "x-world/x-vrml");
            this.put(".wrz", "x-world/x-vrml");
        }
    };
    private static final Map<String, String> fileTypeMap = new ConcurrentHashMap<String, String>();

    private FileType() {
    }

    public static String putFileType(String fileStreamHexHead, String extName) {
        return fileTypeMap.put(fileStreamHexHead.toLowerCase(), extName);
    }

    public static String removeFileType(String fileStreamHexHead) {
        return fileTypeMap.remove(fileStreamHexHead.toLowerCase());
    }

    public static String getType(String fileStreamHexHead) {
        for (Map.Entry<String, String> fileTypeEntry : fileTypeMap.entrySet()) {
            if (!StringUtils.startWithIgnoreCase(fileStreamHexHead, fileTypeEntry.getKey())) continue;
            return fileTypeEntry.getValue();
        }
        return null;
    }

    public static String getType(InputStream in) throws InstrumentException {
        return FileType.getType(IoUtils.readHex28Upper(in));
    }

    public static String getType(File file) throws InstrumentException {
        FileInputStream in = null;
        try {
            in = IoUtils.toStream(file);
            String string = FileType.getType(in);
            return string;
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static String getTypeByPath(String path) throws InstrumentException {
        return FileType.getType(FileUtils.file(path));
    }

    static {
        fileTypeMap.put("ffd8ffe", IMAGE_TYPE_JPG);
        fileTypeMap.put("89504e470d0a1a0a0000", IMAGE_TYPE_PNG);
        fileTypeMap.put("47494638396126026f01", IMAGE_TYPE_GIF);
        fileTypeMap.put("49492a00227105008037", "tif");
        fileTypeMap.put("424d228c010000000000", IMAGE_TYPE_BMP);
        fileTypeMap.put("424d8240090000000000", IMAGE_TYPE_BMP);
        fileTypeMap.put("424d8e1b030000000000", IMAGE_TYPE_BMP);
        fileTypeMap.put("41433130313500000000", "dwg");
        fileTypeMap.put("3c21444f435459504520", "html");
        fileTypeMap.put("3c21646f637479706520", "htm");
        fileTypeMap.put("48544d4c207b0d0a0942", "css");
        fileTypeMap.put("696b2e71623d696b2e71", "js");
        fileTypeMap.put("7b5c727466315c616e73", "rtf");
        fileTypeMap.put("38425053000100000000", IMAGE_TYPE_PSD);
        fileTypeMap.put("46726f6d3a203d3f6762", "eml");
        fileTypeMap.put("d0cf11e0a1b11ae10000", "doc");
        fileTypeMap.put("d0cf11e0a1b11ae10000", "vsd");
        fileTypeMap.put("5374616E64617264204A", "mdb");
        fileTypeMap.put("252150532D41646F6265", "ps");
        fileTypeMap.put("255044462d312e", "pdf");
        fileTypeMap.put("2e524d46000000120001", "rmvb");
        fileTypeMap.put("464c5601050000000900", "flv");
        fileTypeMap.put("00000020667479706d70", "mp4");
        fileTypeMap.put("49443303000000002176", "mp3");
        fileTypeMap.put("000001ba210001000180", "mpg");
        fileTypeMap.put("3026b2758e66cf11a6d9", "wmv");
        fileTypeMap.put("52494646e27807005741", "wav");
        fileTypeMap.put("52494646d07d60074156", "avi");
        fileTypeMap.put("4d546864000000060001", "mid");
        fileTypeMap.put("526172211a0700cf9073", "rar");
        fileTypeMap.put("235468697320636f6e66", "ini");
        fileTypeMap.put("504B03040a0000000000", "jar");
        fileTypeMap.put("504B0304140008000800", "jar");
        fileTypeMap.put("504B0304140006000800", "docx");
        fileTypeMap.put("504B0304140006000800", "xlsx");
        fileTypeMap.put("D0CF11E0A1B11AE10", "xls");
        fileTypeMap.put("504B0304", "zip");
        fileTypeMap.put("4d5a9000030000000400", "exe");
        fileTypeMap.put("3c25402070616765206c", "jsp");
        fileTypeMap.put("4d616e69666573742d56", "mf");
        fileTypeMap.put("3c3f786d6c2076657273", "xml");
        fileTypeMap.put("494e5345525420494e54", "sql");
        fileTypeMap.put("7061636b616765207765", "java");
        fileTypeMap.put("406563686f206f66660d", "bat");
        fileTypeMap.put("1f8b0800000000000000", "gz");
        fileTypeMap.put("6c6f67346a2e726f6f74", "properties");
        fileTypeMap.put("cafebabe0000002e0041", "class");
        fileTypeMap.put("49545346030000006000", "chm");
        fileTypeMap.put("04000000010000001300", "mxp");
        fileTypeMap.put("d0cf11e0a1b11ae10000", "wps");
        fileTypeMap.put("6431303a637265617465", "torrent");
        fileTypeMap.put("6D6F6F76", "mov");
        fileTypeMap.put("FF575043", "wpd");
        fileTypeMap.put("CFAD12FEC5FD746F", "dbx");
        fileTypeMap.put("2142444E", "pst");
        fileTypeMap.put("AC9EBD8F", "qdf");
        fileTypeMap.put("E3828596", "pwl");
        fileTypeMap.put("2E7261FD", "ram");
    }
}

