/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.utils.StringUtils;

public class NumberChinese {
    public static String format(double amount, boolean isUseTraditional) {
        return NumberChinese.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        String[] numArray;
        String[] stringArray = numArray = isUseTraditional ? Normal.TRADITIONAL_DIGITS : Normal.SIMPLE_DIGITS;
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount = -amount;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int numParts = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++numParts;
            temp /= 10000L;
            ++i;
        }
        boolean beforeWanIsZero = true;
        String chineseStr = "";
        for (int i2 = 0; i2 < numParts; ++i2) {
            String partChinese = NumberChinese.toChinese(parts[i2], isUseTraditional);
            if (i2 % 2 == 0) {
                beforeWanIsZero = StringUtils.isEmpty(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    chineseStr = "\u4ebf" + chineseStr;
                } else if ("".equals(partChinese) && !beforeWanIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                } else {
                    if (parts[i2 - 1] < 1000 && parts[i2 - 1] > 0) {
                        chineseStr = "\u96f6" + chineseStr;
                    }
                    chineseStr = "\u4e07" + chineseStr;
                }
            }
            chineseStr = partChinese + chineseStr;
        }
        if ("".equals(chineseStr)) {
            chineseStr = numArray[0];
        }
        if (negative) {
            chineseStr = "\u8d1f" + chineseStr;
        }
        if (numFen != 0 || numJiao != 0) {
            chineseStr = numFen == 0 ? chineseStr + (isMoneyMode ? "\u5143" : "\u70b9") + numArray[numJiao] + (isMoneyMode ? "\u89d2" : "") : (numJiao == 0 ? chineseStr + (isMoneyMode ? "\u5143\u96f6" : "\u70b9\u96f6") + numArray[numFen] + (isMoneyMode ? "\u5206" : "") : chineseStr + (isMoneyMode ? "\u5143" : "\u70b9") + numArray[numJiao] + (isMoneyMode ? "\u89d2" : "") + numArray[numFen] + (isMoneyMode ? "\u5206" : ""));
        } else if (isMoneyMode) {
            chineseStr = chineseStr + "\u5143\u6574";
        }
        return chineseStr;
    }

    private static String toChinese(int amountPart, boolean isUseTraditional) {
        String[] numArray = isUseTraditional ? Normal.TRADITIONAL_DIGITS : Normal.SIMPLE_DIGITS;
        String[] units = isUseTraditional ? Normal.TRADITIONAL_UNITS : Normal.SIMPLE_UNITS;
        int temp = amountPart;
        String chineseStr = "";
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0 && temp != 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                }
                lastIsZero = true;
            } else {
                chineseStr = numArray[digit] + units[i] + chineseStr;
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr;
    }
}

