/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.StrBuilder;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CharUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.PatternUtils;
import org.aoju.bus.core.utils.TextUtils;

public class StringUtils
extends TextUtils {
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static final String[] trim(String[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        String[] resultArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String param = array[i];
            resultArray[i] = StringUtils.trim(param);
        }
        return resultArray;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String toString(Object obj) {
        return StringUtils.toString(obj, "");
    }

    public static String toString(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.toString();
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().equals("");
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values != null && values.length != 0) {
            String[] var2 = values;
            int var3 = values.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String value = var2[var4];
                result &= !StringUtils.isEmpty(value);
            }
        } else {
            result = false;
        }
        return result;
    }

    public static byte[] base64ToByte(String str) {
        try {
            if (str == null) {
                return null;
            }
            return Base64.getDecoder().decode(str);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String str) {
        try {
            if (str == null) {
                return null;
            }
            return new String(StringUtils.base64ToByte(str), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String str, String charset) {
        try {
            if (str == null) {
                return null;
            }
            return new String(StringUtils.base64ToByte(str), charset);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String toBase64(byte[] bts) {
        if (bts == null || bts.length == 0) {
            return null;
        }
        return Base64.getEncoder().encodeToString(bts);
    }

    public static String toBase64(String oldStr) {
        if (oldStr == null) {
            return null;
        }
        byte[] bts = oldStr.getBytes();
        return Base64.getEncoder().encodeToString(bts);
    }

    public static String toBase64(String oldStr, String charset) {
        try {
            if (oldStr == null) {
                return null;
            }
            byte[] bts = oldStr.getBytes(charset);
            return Base64.getEncoder().encodeToString(bts);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static byte[] hexStringToByte(String hex) {
        if (StringUtils.isEmpty(hex)) {
            return new byte[0];
        }
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length() / 2; ++i) {
            String subStr = hex.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return bytes;
    }

    public static String toMD5(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data);
            return StringUtils.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String toMD5(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data.getBytes());
            return StringUtils.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String toMD5(String data, String charset) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data.getBytes(charset));
            return StringUtils.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String toFullString(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u0080') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toHalfString(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\ufee0' || c[i] >= '\uff60') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String toUnicode(String input) {
        StringBuffer unicode = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String hexStr = Integer.toHexString(c);
            while (hexStr.length() < 4) {
                hexStr = "0" + hexStr;
            }
            unicode.append("\\u" + hexStr);
        }
        return unicode.toString();
    }

    public static String toUnicode(String str, boolean isSkipAscii) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        TextUtils unicode = StringUtils.create(str.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (isSkipAscii && CharUtils.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexUtils.toUnicodeHex(c));
        }
        return unicode.toString();
    }

    public static String unicodeToString(String input) {
        StringBuffer string = new StringBuffer();
        String[] hex = input.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            string.append((char)data);
        }
        return string.toString();
    }

    public static String unicodeToString(String unicode, boolean isSkipAscii) {
        if (StringUtils.isBlank(unicode)) {
            return unicode;
        }
        if (isSkipAscii) {
            int len = unicode.length();
            TextUtils sb = StringUtils.create(len);
            int i = -1;
            int pos = 0;
            while ((i = StringUtils.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
                sb.append(unicode, pos, i);
                pos = i;
                if (i + 5 < len) {
                    char c = '\u0000';
                    try {
                        c = (char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16);
                        sb.append(c);
                        pos = i + 6;
                    }
                    catch (NumberFormatException e) {
                        sb.append(unicode, pos, i + 2);
                        pos = i + 2;
                    }
                    continue;
                }
                pos = i;
                break;
            }
            if (pos < len) {
                sb.append(unicode, pos, len);
            }
            return sb.toString();
        }
        return StringUtils.unicodeToString(unicode);
    }

    public static String toUrlStr(String input) {
        return StringUtils.toUrlStr(input, "UTF-8");
    }

    public static String toUrlStr(String input, String charset) {
        try {
            return URLEncoder.encode(input, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlStrToString(String input) {
        return StringUtils.urlStrToString(input, "UTF-8");
    }

    public static String urlStrToString(String input, String charset) {
        try {
            return URLDecoder.decode(input, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toDES(String text, String token, String charset) {
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            byte[] btToken = charset == null ? token.getBytes() : token.getBytes(charset);
            byte[] btText = charset == null ? text.getBytes() : text.getBytes(charset);
            DESKeySpec desKeySpec = new DESKeySpec(btToken);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(btToken);
            cipher.init(1, (Key)secretKey, iv);
            byte[] bts = cipher.doFinal(btText);
            return StringUtils.toBase64(bts);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String toDES(String text, String token) {
        return StringUtils.toDES(text, token, null);
    }

    public static String DESToString(String text, String token, String charset) {
        try {
            byte[] bytesrc = StringUtils.base64ToByte(text);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            byte[] btToken = charset == null ? token.getBytes() : token.getBytes(charset);
            DESKeySpec desKeySpec = new DESKeySpec(btToken);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(btToken);
            cipher.init(2, (Key)secretKey, iv);
            byte[] retByte = cipher.doFinal(bytesrc);
            return charset == null ? new String(retByte) : new String(retByte, charset);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String DESToString(String text, String token) {
        return StringUtils.DESToString(text, token, null);
    }

    public static String toAES(String text, String token, String charset) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(charset == null ? token.getBytes() : token.getBytes(charset)));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] btText = charset == null ? text.getBytes() : text.getBytes(charset);
            cipher.init(1, key);
            byte[] bts = cipher.doFinal(btText);
            return StringUtils.toBase64(bts);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String toAES(String text, String token) {
        return StringUtils.toAES(text, token, null);
    }

    public static String AESToString(String text, String token, String charset) {
        try {
            byte[] btText = StringUtils.base64ToByte(text);
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(charset == null ? token.getBytes() : token.getBytes(charset)));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] bts = cipher.doFinal(btText);
            return charset == null ? new String(bts) : new String(bts, charset);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String AESToString(String text, String token) {
        return StringUtils.AESToString(text, token, null);
    }

    public static String compress2(byte[] bts) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte now = 0;
            int count = 0;
            for (int i = 0; i < bts.length; ++i) {
                if (count == 0) {
                    now = bts[i];
                    ++count;
                    continue;
                }
                if (now == bts[i] && count < 255) {
                    ++count;
                    continue;
                }
                bout.write(count);
                bout.write(now);
                count = 0;
                --i;
            }
            bout.write(count);
            bout.write(now);
            count = 0;
            bout.flush();
            bts = bout.toByteArray();
            ByteArrayOutputStream head = new ByteArrayOutputStream();
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            for (int i = 0; i < bts.length; i += 2) {
                if (count == 0) {
                    now = bts[i];
                    count = 1;
                    body.write(bts[i + 1]);
                    continue;
                }
                if (now == bts[i] && count < 255) {
                    ++count;
                    body.write(bts[i + 1]);
                    continue;
                }
                head.write(count);
                head.write(now);
                count = 0;
                i -= 2;
            }
            head.write(count);
            head.write(now);
            count = 0;
            head.flush();
            body.flush();
            int size = head.size();
            ByteArrayOutputStream all = new ByteArrayOutputStream();
            all.write(size >> 24);
            all.write(size >> 16);
            all.write(size >> 8);
            all.write(size);
            all.write(head.toByteArray());
            all.write(body.toByteArray());
            all.flush();
            return StringUtils.toBase64(all.toByteArray());
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String compress2(String val, String ... charset) {
        if (StringUtils.isEmpty(val)) {
            return val;
        }
        try {
            return StringUtils.compress2(charset != null && charset.length > 0 ? val.getBytes(charset[0]) : val.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException(e);
        }
    }

    public static String unCompress2(String val, String ... charset) {
        try {
            byte[] bts = StringUtils.base64ToByte(val);
            int size = (bts[0] << 24) + (bts[1] << 16) + (bts[2] << 8) + bts[3];
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            int count = 4 + size;
            for (int i = 4; i < 4 + size; i += 2) {
                int k = bts[i];
                byte bt = bts[i + 1];
                for (int j = 0; j < k; ++j) {
                    body.write(bt);
                    body.write(bts[count]);
                    ++count;
                }
            }
            body.flush();
            bts = body.toByteArray();
            ByteArrayOutputStream all = new ByteArrayOutputStream();
            for (int i = 0; i < bts.length; i += 2) {
                for (int j = 0; j < bts[i]; ++j) {
                    all.write(bts[i + 1]);
                }
            }
            all.flush();
            bts = all.toByteArray();
            return charset != null && charset.length > 0 ? new String(bts, charset[0]) : new String(bts);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String compress(byte[] bytes) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(bytes);
            gzip.close();
            return StringUtils.toBase64(out.toByteArray());
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String compress(String val, String ... charset) {
        if (StringUtils.isEmpty(val)) {
            return val;
        }
        try {
            return StringUtils.compress(charset != null && charset.length > 0 ? val.getBytes(charset[0]) : val.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException(e);
        }
    }

    public static String unCompress(String val, String ... charset) {
        try {
            if (StringUtils.isEmpty(val)) {
                return val;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(StringUtils.base64ToByte(val));
            GZIPInputStream gzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            int n = 0;
            while ((n = gzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            return charset != null && charset.length > 0 ? new String(out.toByteArray(), charset[0]) : new String(out.toByteArray());
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static String substringBetween(String str, String open, String close) {
        if (str != null && open != null && close != null) {
            int end;
            int start = str.indexOf(open);
            if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
                return str.substring(start + open.length(), end);
            }
            return null;
        }
        return null;
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StringUtils.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StringUtils.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.equals(str2);
    }

    public static String format(String val, Object ... argArray) {
        if (StringUtils.isBlank(val) || ArrayUtils.isEmpty(argArray)) {
            return val;
        }
        int strPatternLength = val.length();
        StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
            int delimIndex = val.indexOf("{}", handledPosition);
            if (delimIndex == -1) {
                if (handledPosition == 0) {
                    return val;
                }
                sbuf.append(val, handledPosition, strPatternLength);
                return sbuf.toString();
            }
            if (delimIndex > 0 && val.charAt(delimIndex - 1) == '\\') {
                if (delimIndex > 1 && val.charAt(delimIndex - 2) == '\\') {
                    sbuf.append(val, handledPosition, delimIndex - 1);
                    sbuf.append(StringUtils.utf8Str(argArray[argIndex]));
                    handledPosition = delimIndex + 2;
                    continue;
                }
                --argIndex;
                sbuf.append(val, handledPosition, delimIndex - 1);
                sbuf.append('{');
                handledPosition = delimIndex + 1;
                continue;
            }
            sbuf.append(val, handledPosition, delimIndex);
            sbuf.append(StringUtils.utf8Str(argArray[argIndex]));
            handledPosition = delimIndex + 2;
        }
        sbuf.append(val, handledPosition, val.length());
        return sbuf.toString();
    }

    public static String utf8Str(Object obj) {
        return StringUtils.str(obj, StandardCharsets.UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StringUtils.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringUtils.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtils.isArray(obj)) {
            return ArrayUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StringUtils.str(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StringUtils.str(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringUtils.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringUtils.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StringUtils.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return StringUtils.sub(string, fromIndex, string.length());
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static List<String> splitPath(String str) {
        return StringUtils.splitPath(str, 0);
    }

    public static List<String> splitPath(String str, int limit) {
        return StringUtils.split(str, '/', limit, true, true);
    }

    public static String[] splitPathToArray(String str) {
        return StringUtils.toArray(StringUtils.splitPath(str));
    }

    public static String[] splitPathToArray(String str, int limit) {
        return StringUtils.toArray(StringUtils.splitPath(str, limit));
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return StringUtils.splitTrim(str.toString(), separator, true);
    }

    public static List<String> splitTrim(String str, char separator, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, 0, true, ignoreEmpty);
    }

    public static List<String> splitTrim(String str, String separator, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, true, ignoreEmpty);
    }

    public static List<String> splitTrim(String str, char separator, int limit, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, limit, true, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str, String separator, int limit, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, limit, true, ignoreEmpty);
    }

    public static List<String> splitIgnoreCase(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitIgnoreCase(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitTrimIgnoreCase(String str, String separator, int limit, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, limit, true, ignoreEmpty, true);
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit) {
        if (null == str) {
            return new String[0];
        }
        return StringUtils.splitToArray(str.toString(), separator, limit, false, false);
    }

    public static String[] splitToArray(String str, int limit) {
        return StringUtils.toArray(StringUtils.split(str, limit));
    }

    public static String[] splitToArray(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.toArray(StringUtils.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitToArray(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.toArray(StringUtils.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitToArray(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.toArray(StringUtils.split(str, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static List<String> splitByRegex(String str, String separatorRegex, int limit, boolean isTrim, boolean ignoreEmpty) {
        Pattern pattern = PatternUtils.get(separatorRegex);
        return StringUtils.split(str, pattern, limit, isTrim, ignoreEmpty);
    }

    public static String[] splitByLength(String text, int len) {
        int partCount = text.length() / len;
        int lastPartCount = text.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? text.substring(i * len, i * len + lastPartCount) : text.substring(i * len, i * len + len);
        }
        return strs;
    }

    public static String split(String str) {
        return StringUtils.split(str, ",", ",");
    }

    public static String split(String str, CharSequence separator, CharSequence reserve) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotEmpty(str)) {
            String[] arr = StringUtils.split((CharSequence)str, separator);
            for (int i = 0; i < arr.length; ++i) {
                if (i == 0) {
                    sb.append("'").append(arr[i]).append("'");
                    continue;
                }
                sb.append(reserve).append("'").append(arr[i]).append("'");
            }
        }
        return sb.toString();
    }

    public static String[] split(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StringUtils.splitToArray(str.toString(), separatorStr, 0, false, false);
    }

    public static List<String> split(String str, char separator) {
        return StringUtils.split((CharSequence)str, separator, -1);
    }

    public static List<String> split(CharSequence str, char separator) {
        return StringUtils.split(str, separator, 0);
    }

    public static List<String> split(String str, int limit) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringUtils.addToList(new ArrayList<String>(1), str, true, true);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!CharUtils.isBlankChar(str.charAt(i))) continue;
            StringUtils.addToList(list, str.substring(start, i), true, true);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StringUtils.addToList(list, str.substring(start, len), true, true);
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return StringUtils.split(str.toString(), separator, limit, false, false);
    }

    public static List<String> split(String str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, String separator, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringUtils.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (null == separatorPattern) {
            return StringUtils.split(str, limit);
        }
        Matcher matcher = separatorPattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        while (matcher.find()) {
            StringUtils.addToList(list, str.substring(start, matcher.start()), isTrim, ignoreEmpty);
            start = matcher.end();
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StringUtils.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringUtils.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : 16);
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!NumberUtils.equals(separator, str.charAt(i), ignoreCase)) continue;
            StringUtils.addToList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StringUtils.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringUtils.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (StringUtils.isEmpty(separator)) {
            return StringUtils.split(str, limit);
        }
        if (separator.length() == 1) {
            return StringUtils.split(str, separator.charAt(0), limit, isTrim, ignoreEmpty, ignoreCase);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int separatorLen = separator.length();
        int start = 0;
        int i = 0;
        while (i < len && (i = StringUtils.indexOf((CharSequence)str, separator, start, ignoreCase)) > -1) {
            StringUtils.addToList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + separatorLen;
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StringUtils.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return StringUtils.indexOf(str, searchChar) > -1;
    }

    public static String trim(CharSequence str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && CharUtils.isBlankChar(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharUtils.isBlankChar(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.toString().substring(start, end);
        }
        return str.toString();
    }

    public static boolean startWith(CharSequence str, char c) {
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean isIgnoreCase) {
        if (null == str || null == prefix) {
            return null == str && null == prefix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase());
        }
        return str.toString().startsWith(prefix.toString());
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return StringUtils.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StringUtils.startWith(str, prefix, true);
    }

    public static String capitalize(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            char firstChar = str.charAt(0);
            return Character.isTitleCase(firstChar) ? str : new StringBuilder(strLen).append(Character.toTitleCase(firstChar)).append(str.substring(1)).toString();
        }
        return str;
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            char firstChar = str.charAt(0);
            return Character.isLowerCase(firstChar) ? str : new StringBuilder(strLen).append(Character.toLowerCase(firstChar)).append(str.substring(1)).toString();
        }
        return str;
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StringUtils.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StringUtils.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtils.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtils.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StringUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtils.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtils.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i > 0; --i) {
            if (!StringUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringUtils.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence str, int count) {
        int n;
        if (null == str) {
            return null;
        }
        if (count <= 0) {
            return "";
        }
        if (count == 1 || str.length() == 0) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String reverse(String str) {
        char[] chars = str.toCharArray();
        ArrayUtils.reverse(chars);
        return new String(chars);
    }

    public static byte[] bytes(CharSequence str) {
        return StringUtils.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return StringUtils.bytes(str, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String toUnderlineCase(CharSequence camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        int length = camelCaseStr.length();
        StringBuilder sb = new StringBuilder();
        boolean isPreUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = camelCaseStr.charAt(i);
            boolean isNextUpperCase = true;
            if (i < length - 1) {
                isNextUpperCase = Character.isUpperCase(camelCaseStr.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(isPreUpperCase && isNextUpperCase || i <= 0)) {
                    sb.append("_");
                }
                isPreUpperCase = true;
            } else {
                isPreUpperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        return StringUtils.lowerFirst(StringUtils.removePrefix(str, prefix));
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(prefix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StringUtils.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(prefix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return StringUtils.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StringUtils.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StringUtils.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + StringUtils.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + StringUtils.subSuf(str, 1);
        }
        return str.toString();
    }

    private static List<String> addToList(List<String> list, String part, boolean isTrim, boolean ignoreEmpty) {
        if (isTrim) {
            part = part.trim();
        }
        if (!ignoreEmpty || !part.isEmpty()) {
            list.add(part);
        }
        return list;
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String toCamelCase(CharSequence name) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (name2.contains("_")) {
            StringBuilder sb = new StringBuilder(name2.length());
            boolean upperCase = false;
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return name2;
    }

    public static String nullToEmpty(CharSequence str) {
        return StringUtils.nullToDefault(str, "");
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static boolean isAllCharMatch(CharSequence value, org.aoju.bus.core.lang.Matcher<Character> matcher) {
        if (StringUtils.isBlank(value)) {
            return false;
        }
        int len = value.length();
        boolean isAllMatch = true;
        for (int i = 0; i < len; ++i) {
            isAllMatch &= matcher.match(Character.valueOf(value.charAt(i)));
        }
        return isAllMatch;
    }

    public static String remove(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replace(str, remove, "", -1);
    }

    public static String removeIgnoreCase(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replaceIgnoreCase(str, remove, "", -1);
    }

    public static String remove(String str, char remove) {
        if (StringUtils.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String removeAll(String text, String regex) {
        return StringUtils.replaceAll(text, regex, "");
    }

    public static String removeFirst(String text, String regex) {
        return StringUtils.replaceFirst(text, regex, "");
    }

    public static String replaceAll(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String replaceFirst(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceFirst(regex, replacement);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement) {
        return StringUtils.replaceIgnoreCase(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        int start;
        int end;
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        String searchText = text;
        if (ignoreCase) {
            searchText = text.toLowerCase();
            searchString = searchString.toLowerCase();
        }
        if ((end = searchText.indexOf(searchString, start = 0)) == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = searchText.indexOf(searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, true);
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach(text, searchList, replacementList, false, 0);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        int timeToLive = searchList == null ? 0 : searchList.length;
        return StringUtils.replaceEach(text, searchList, replacementList, true, timeToLive);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        if (text == null || text.isEmpty() || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return StringUtils.replaceEach(result, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = "";
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String replaceIgnoreCase(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return StringUtils.replace(str, 0, searchStr, replacement, true);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return StringUtils.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return StringUtils.replace(str, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchStr)) {
            return StringUtils.str(str);
        }
        if (null == replacement) {
            replacement = "";
        }
        int strLength = str.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return StringUtils.str(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        TextUtils result = StringUtils.create(strLength + 16);
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        int index = fromIndex;
        while ((index = StringUtils.indexOf(str, searchStr, preIndex, ignoreCase)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StringUtils.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StringUtils.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StringUtils.replace(str, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(chars)) {
            return StringUtils.str(str);
        }
        return StringUtils.replaceChars(str, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(chars)) {
            return StringUtils.str(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static String cleanBlank(CharSequence str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (CharUtils.isBlankChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String wrap(CharSequence str, CharSequence prefixAndSuffix) {
        return StringUtils.wrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return StringUtils.nullToEmpty(prefix).concat(StringUtils.nullToEmpty(str)).concat(StringUtils.nullToEmpty(suffix));
    }

    public static String[] wrapAll(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return StringUtils.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = StringUtils.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence str, String prefix, String suffix) {
        if (StringUtils.isWrap(str, prefix, suffix)) {
            return StringUtils.sub(str, prefix.length(), str.length() - suffix.length());
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return StringUtils.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        return StringUtils.unWrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str, String prefix, String suffix) {
        if (ArrayUtils.hasNull(str, prefix, suffix)) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence str, String wrapper) {
        return StringUtils.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char wrapper) {
        return StringUtils.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static boolean endWith(CharSequence str, char c) {
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str || null == suffix) {
            return null == str && null == suffix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return StringUtils.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringUtils.endWith(str, suffix, true);
    }

    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        return StringUtils.strip(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StringUtils.startWith((CharSequence)str2, prefix)) {
            from = prefix.length();
        }
        if (StringUtils.endWith((CharSequence)str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        return StringUtils.stripIgnoreCase(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StringUtils.startWithIgnoreCase(str2, prefix)) {
            from = prefix.length();
        }
        if (StringUtils.endWithIgnoreCase(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        String prefix2;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(prefix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (!str2.startsWith(prefix2 = prefix.toString())) {
            return prefix2.concat(str2);
        }
        return str2;
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        String suffix2;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (!str2.endsWith(suffix2 = suffix.toString())) {
            return str2.concat(suffix2);
        }
        return str2;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtils.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!StringUtils.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtils.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str, char ... testChars) {
        if (!StringUtils.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayUtils.contains(testChars, str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharUtils.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtils.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!StringUtils.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return StringUtils.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static boolean isSurround(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static String toString(Class<?>[] parameterTypes) {
        if (ArrayUtils.isEmpty(parameterTypes)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Class<?> clazz : parameterTypes) {
            builder.append("," + clazz.getCanonicalName());
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static String toString(String[] values) {
        if (ArrayUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append("," + value);
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isBlank(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtils.isEmpty(css)) {
            return false;
        }
        return Stream.of(css).allMatch(StringUtils::isNotBlank);
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static String replaceBlank(String str) {
        String val = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            val = m.replaceAll("");
        }
        return val;
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[0]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        return StringUtils.toStringArray(Collections.list(enumeration));
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtils.repeat(padChar, pads));
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtils.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String buildString(Object original, String middle, int prefixLength) {
        if (ObjectUtils.isNull(original)) {
            return null;
        }
        String string = original.toString();
        int stringLength = string.length();
        String prefix = "";
        String suffix = "";
        prefix = stringLength >= prefixLength ? string.substring(0, prefixLength) : string.substring(0, stringLength);
        int suffixLength = stringLength - prefix.length() - middle.length();
        if (suffixLength > 0) {
            suffix = string.substring(stringLength - suffixLength);
        }
        return prefix + middle + suffix;
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        StrBuilder sb = new StrBuilder();
        for (CharSequence str : strs) {
            sb.append(isNullToEmpty ? StringUtils.nullToEmpty(str) : str);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return cs == null ? 0 : cs.toString().getBytes(charset).length;
    }

    public static String swapCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static String fillBefore(String str, char filledChar, int len) {
        return StringUtils.fill(str, filledChar, len, true);
    }

    public static String fillAfter(String strVal, char charVal, int len) {
        return StringUtils.fill(strVal, charVal, len, false);
    }

    public static String fill(String strVal, char charVal, int len, boolean isPre) {
        int strLen = strVal.length();
        if (strLen > len) {
            return strVal;
        }
        String filled = StringUtils.repeat(charVal, len - strLen);
        return isPre ? filled.concat(strVal) : strVal.concat(filled);
    }

    public static String fill(int count, char charVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        char[] chs = new char[count];
        for (int i = 0; i < count; ++i) {
            chs[i] = charVal;
        }
        return new String(chs);
    }

    public static String fill(int count, String strVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strVal);
        }
        return sb.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StrBuilder strBuilder() {
        return new StrBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StrBuilder strBuilder(int capacity) {
        return new StrBuilder(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StrBuilder strBuilder(CharSequence ... strs) {
        return new StrBuilder(strs);
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (StringUtils.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StringUtils.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String[] cut(CharSequence str, int partLength) {
        if (null == str) {
            return null;
        }
        int len = str.length();
        if (len < partLength) {
            return new String[]{str.toString()};
        }
        int part = NumberUtils.count(len, partLength);
        String[] array = new String[part];
        String str2 = str.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String brief(CharSequence str, int maxLength) {
        if (null == str) {
            return null;
        }
        if (str.length() + 3 <= maxLength) {
            return str.toString();
        }
        int w = maxLength / 2;
        int l = str.length();
        String str2 = str.toString();
        return StringUtils.format("{}...{}", str2.substring(0, maxLength - w), str2.substring(l - w));
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringUtils.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static String firstCharToLower(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpper(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String cleanText(String txt) {
        if (txt == null) {
            return null;
        }
        return Pattern.compile("[`'\"|/,;()-+*%#\u00b7\u2022\ufffd\u3000\\s]").matcher(txt).replaceAll("");
    }

    public static String cleanIdentifier(String param) {
        if (param == null) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            paramBuilder.append(c);
        }
        return paramBuilder.toString();
    }
}

