/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.HealthUtils;

public class JavaRuntimeInfo {
    private final String JAVA_RUNTIME_NAME = HealthUtils.get(" java.runtime.name", false);
    private final String JAVA_RUNTIME_VERSION = HealthUtils.get("java.runtime.version", false);
    private final String JAVA_HOME = HealthUtils.get("java.home", false);
    private final String JAVA_EXT_DIRS = HealthUtils.get("java.ext.dirs", false);
    private final String JAVA_ENDORSED_DIRS = HealthUtils.get("java.endorsed.dirs", false);
    private final String JAVA_CLASS_PATH = HealthUtils.get("java.class.path", false);
    private final String JAVA_CLASS_VERSION = HealthUtils.get("java.class.version", false);
    private final String JAVA_LIBRARY_PATH = HealthUtils.get("java.library.path", false);
    private final String SUN_BOOT_CLASS_PATH = HealthUtils.get("sun.boot.class.path", false);
    private final String SUN_ARCH_DATA_MODEL = HealthUtils.get("sun.arch.data.model", false);

    public final String getSunBoothClassPath() {
        return this.SUN_BOOT_CLASS_PATH;
    }

    public final String getSunArchDataModel() {
        return this.SUN_ARCH_DATA_MODEL;
    }

    public final String getName() {
        return this.JAVA_RUNTIME_NAME;
    }

    public final String getVersion() {
        return this.JAVA_RUNTIME_VERSION;
    }

    public final String getHomeDir() {
        return this.JAVA_HOME;
    }

    public final String getExtDirs() {
        return this.JAVA_EXT_DIRS;
    }

    public final String getEndorsedDirs() {
        return this.JAVA_ENDORSED_DIRS;
    }

    public final String getClassPath() {
        return this.JAVA_CLASS_PATH;
    }

    public final String[] getClassPathArray() {
        return StringUtils.split((CharSequence)this.getClassPath(), HealthUtils.get("path.separator", false));
    }

    public final String getClassVersion() {
        return this.JAVA_CLASS_VERSION;
    }

    public final String getLibraryPath() {
        return this.JAVA_LIBRARY_PATH;
    }

    public final String[] getLibraryPathArray() {
        return StringUtils.split((CharSequence)this.getLibraryPath(), HealthUtils.get("path.separator", false));
    }

    public final String getProtocolPackages() {
        return HealthUtils.get("java.protocol.handler.pkgs", true);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        HealthUtils.append(builder, "Java Runtime Name:      ", this.getName());
        HealthUtils.append(builder, "Java Runtime Version:   ", this.getVersion());
        HealthUtils.append(builder, "Java Home Dir:          ", this.getHomeDir());
        HealthUtils.append(builder, "Java Extension Dirs:    ", this.getExtDirs());
        HealthUtils.append(builder, "Java Endorsed Dirs:     ", this.getEndorsedDirs());
        HealthUtils.append(builder, "Java Class Path:        ", this.getClassPath());
        HealthUtils.append(builder, "Java Class Version:     ", this.getClassVersion());
        HealthUtils.append(builder, "Java Library Path:      ", this.getLibraryPath());
        HealthUtils.append(builder, "Java Protocol Packages: ", this.getProtocolPackages());
        return builder.toString();
    }
}

