/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.cache.StateCache;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class CodingProvider
extends DefaultProvider {
    public CodingProvider(Context config) {
        super(config, Registry.CODING);
    }

    public CodingProvider(Context config, StateCache stateCache) {
        super(config, Registry.CODING, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject accessTokenObject = JSONObject.parseObject((String)this.doGetAuthorizationCode(Callback2.getCode()));
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        object = object.getJSONObject("data");
        return Property.builder().uuid(object.getString("id")).username(object.getString("name")).avatar("https://coding.net/" + object.getString("avatar")).blog("https://coding.net/" + object.getString("path")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).gender(Normal.Gender.getGender(object.getString("sex"))).email(object.getString("email")).remark(object.getString("slogan")).token(token).source(this.source.toString()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.getIntValue("code") != 0) {
            throw new InstrumentException(object.getString("msg"));
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "user").queryParam("state", this.getRealState(state)).build();
    }
}

