/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.cache.StateCache;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class GoogleProvider
extends DefaultProvider {
    public GoogleProvider(Context config) {
        super(config, Registry.GOOGLE);
    }

    public GoogleProvider(Context config, StateCache stateCache) {
        super(config, Registry.GOOGLE, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).scope(object.getString("scope")).tokenType(object.getString("token_type")).idToken(object.getString("id_token")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + token.getAccessToken());
        String response = HttpClient.post(this.userInfoUrl(token), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("sub")).username(object.getString("email")).avatar(object.getString("picture")).nickname(object.getString("name")).location(object.getString("locale")).email(object.getString("email")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("scope", "openid%20email%20profile").queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error") || object.containsKey((Object)"error_description")) {
            throw new InstrumentException(object.containsKey((Object)"error") + ":" + object.getString("error_description"));
        }
    }
}

