/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.cache.StateCache;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class HuaweiProvider
extends DefaultProvider {
    public HuaweiProvider(Context config) {
        super(config, Registry.HUAWEI);
    }

    public HuaweiProvider(Context config, StateCache stateCache) {
        super(config, Registry.HUAWEI, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("grant_type", "authorization_code");
        params.put("code", Callback2.getAuthorization_code());
        params.put("client_id", this.config.getClientId());
        params.put("client_secret", this.config.getClientSecret());
        params.put("redirect_uri", this.config.getRedirectUri());
        HttpClient.post(this.source.accessToken(), params);
        return this.getAuthToken(params);
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nsp_ts", System.currentTimeMillis());
        params.put("access_token", token.getAccessToken());
        params.put("nsp_fmt", "JS");
        params.put("nsp_svc", "OpenUP.User.getInfo");
        String response = HttpClient.post(this.source.userInfo(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        Normal.Gender gender = this.getRealGender(object);
        return Property.builder().uuid(object.getString("userID")).username(object.getString("userName")).nickname(object.getString("userName")).gender(gender).avatar(object.getString("headPictureURL")).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client_id", this.config.getClientId());
        params.put("client_secret", this.config.getClientSecret());
        params.put("refresh_token", token.getRefreshToken());
        params.put("grant_type", "refresh_token");
        HttpClient.post(this.source.accessToken(), params);
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getAuthToken(params)).build();
    }

    private AccToken getAuthToken(Map<String, Object> params) {
        String response = HttpClient.post(this.source.accessToken(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("access_type", "offline").queryParam("scope", "https%3A%2F%2Fwww.huawei.com%2Fauth%2Faccount%2Fbase.profile").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromBaseUrl(this.source.accessToken()).queryParam("grant_type", "authorization_code").queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("nsp_ts", System.currentTimeMillis()).queryParam("access_token", token.getAccessToken()).queryParam("nsp_fmt", "JS").queryParam("nsp_svc", "OpenUP.User.getInfo").build();
    }

    private Normal.Gender getRealGender(JSONObject object) {
        int genderCodeInt = object.getIntValue("gender");
        String genderCode = genderCodeInt == 1 ? "0" : (genderCodeInt == 0 ? "1" : genderCodeInt + "");
        return Normal.Gender.getGender(genderCode);
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"NSP_STATUS")) {
            throw new InstrumentException(object.getString("error"));
        }
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("sub_error") + ":" + object.getString("error_description"));
        }
    }
}

