/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.cache.StateCache;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class OschinaProvider
extends DefaultProvider {
    public OschinaProvider(Context config) {
        super(config, Registry.OSCHINA);
    }

    public OschinaProvider(Context config, StateCache stateCache) {
        super(config, Registry.OSCHINA, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).uid(object.getString("uid")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("id")).username(object.getString("name")).nickname(object.getString("name")).avatar(object.getString("avatar")).blog(object.getString("url")).location(object.getString("location")).gender(Normal.Gender.getGender(object.getString("gender"))).email(object.getString("email")).token(token).source(this.source.toString()).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("dataType", "json").build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("dataType", "json").build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error_description"));
        }
    }
}

