/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.cache.StateCache;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class TaobaoProvider
extends DefaultProvider {
    public TaobaoProvider(Context config) {
        super(config, Registry.TAOBAO);
    }

    public TaobaoProvider(Context config, StateCache stateCache) {
        super(config, Registry.TAOBAO, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return AccToken.builder().accessCode(Callback2.getCode()).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String response = this.doPostAuthorizationCode(token.getAccessCode());
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error_description"));
        }
        token.setAccessToken(object.getString("access_token"));
        token.setRefreshToken(object.getString("refresh_token"));
        token.setExpireIn(object.getIntValue("expires_in"));
        token.setUid(object.getString("taobao_user_id"));
        token.setOpenId(object.getString("taobao_open_uid"));
        String nick = TaobaoProvider.urlDecode(object.getString("taobao_user_nick"));
        return Property.builder().uuid(object.getString("taobao_user_id")).username(nick).nickname(nick).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("view", "web").queryParam("state", this.getRealState(state)).build();
    }
}

