/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.aio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.socket.SocketUtils;
import org.aoju.bus.socket.origin.OriginConfig;
import org.aoju.bus.socket.origin.aio.IoAction;
import org.aoju.bus.socket.origin.aio.ReadHandler;

public class AioSession {
    private static final ReadHandler READ_HANDLER = new ReadHandler();
    private AsynchronousSocketChannel channel;
    private IoAction<ByteBuffer> ioAction;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private long readTimeout;
    private long writeTimeout;

    public AioSession(AsynchronousSocketChannel channel, IoAction<ByteBuffer> ioAction, OriginConfig config) {
        this.channel = channel;
        this.readBuffer = ByteBuffer.allocate(config.getReadBufferSize());
        this.writeBuffer = ByteBuffer.allocate(config.getWriteBufferSize());
        this.ioAction = ioAction;
    }

    public AsynchronousSocketChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public ByteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.ioAction;
    }

    public SocketAddress getRemoteAddress() {
        return SocketUtils.getRemoteAddress(this.channel);
    }

    public AioSession read() {
        return this.read(READ_HANDLER);
    }

    public AioSession read(CompletionHandler<Integer, AioSession> handler) {
        if (this.isOpen()) {
            this.readBuffer.clear();
            this.channel.read(this.readBuffer, Math.max(this.readTimeout, 0L), TimeUnit.MILLISECONDS, this, handler);
        }
        return this;
    }

    public AioSession writeAndClose(ByteBuffer data) {
        this.write(data);
        return this.closeOut();
    }

    public Future<Integer> write(ByteBuffer data) {
        return this.channel.write(data);
    }

    public AioSession write(ByteBuffer data, CompletionHandler<Integer, AioSession> handler) {
        this.channel.write(data, Math.max(this.writeTimeout, 0L), TimeUnit.MILLISECONDS, this, handler);
        return this;
    }

    public boolean isOpen() {
        return null == this.channel ? false : this.channel.isOpen();
    }

    public AioSession closeIn() {
        if (null != this.channel) {
            try {
                this.channel.shutdownInput();
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
        return this;
    }

    public AioSession closeOut() {
        if (null != this.channel) {
            try {
                this.channel.shutdownOutput();
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
        return this;
    }

    public void close() {
        IoUtils.close(this.channel);
        this.readBuffer = null;
        this.writeBuffer = null;
    }

    protected void callbackRead() {
        this.readBuffer.flip();
        this.ioAction.doAction(this, this.readBuffer);
    }
}

