/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.oauth;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Complex;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Provider;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.cache.StateCache;
import org.aoju.bus.oauth.provider.AlipayProvider;
import org.aoju.bus.oauth.provider.BaiduProvider;
import org.aoju.bus.oauth.provider.CodingProvider;
import org.aoju.bus.oauth.provider.CsdnProvider;
import org.aoju.bus.oauth.provider.DingTalkProvider;
import org.aoju.bus.oauth.provider.DouyinProvider;
import org.aoju.bus.oauth.provider.FacebookProvider;
import org.aoju.bus.oauth.provider.GiteeProvider;
import org.aoju.bus.oauth.provider.GithubProvider;
import org.aoju.bus.oauth.provider.GitlabProvider;
import org.aoju.bus.oauth.provider.GoogleProvider;
import org.aoju.bus.oauth.provider.HuaweiProvider;
import org.aoju.bus.oauth.provider.KujialeProvider;
import org.aoju.bus.oauth.provider.LinkedinProvider;
import org.aoju.bus.oauth.provider.MiProvider;
import org.aoju.bus.oauth.provider.MicrosoftProvider;
import org.aoju.bus.oauth.provider.OschinaProvider;
import org.aoju.bus.oauth.provider.PinterestProvider;
import org.aoju.bus.oauth.provider.QqProvider;
import org.aoju.bus.oauth.provider.RenrenProvider;
import org.aoju.bus.oauth.provider.StackOverflowProvider;
import org.aoju.bus.oauth.provider.TaobaoProvider;
import org.aoju.bus.oauth.provider.TeambitionProvider;
import org.aoju.bus.oauth.provider.TencentCloudProvider;
import org.aoju.bus.oauth.provider.ToutiaoProvider;
import org.aoju.bus.oauth.provider.WeChatEEProvider;
import org.aoju.bus.oauth.provider.WeChatProvider;
import org.aoju.bus.oauth.provider.WeiboProvider;
import org.aoju.bus.spring.oauth.AuthProperties;

public class AuthProviderService {
    private final AuthProperties properties;
    private final StateCache stateCache;

    public Provider get(Complex complex) {
        Context config = this.properties.getType().get(complex);
        if (Registry.GITHUB.equals(complex)) {
            return new GithubProvider(config, this.stateCache);
        }
        if (Registry.WEIBO.equals(complex)) {
            return new WeiboProvider(config, this.stateCache);
        }
        if (Registry.GITEE.equals(complex)) {
            return new GiteeProvider(config, this.stateCache);
        }
        if (Registry.DINGTALK.equals(complex)) {
            return new DingTalkProvider(config, this.stateCache);
        }
        if (Registry.BAIDU.equals(complex)) {
            return new BaiduProvider(config, this.stateCache);
        }
        if (Registry.CSDN.equals(complex)) {
            return new CsdnProvider(config, this.stateCache);
        }
        if (Registry.CODING.equals(complex)) {
            return new CodingProvider(config, this.stateCache);
        }
        if (Registry.TENCENT_CLOUD.equals(complex)) {
            return new TencentCloudProvider(config, this.stateCache);
        }
        if (Registry.OSCHINA.equals(complex)) {
            return new OschinaProvider(config, this.stateCache);
        }
        if (Registry.ALIPAY.equals(complex)) {
            return new AlipayProvider(config, this.stateCache);
        }
        if (Registry.QQ.equals(complex)) {
            return new QqProvider(config, this.stateCache);
        }
        if (Registry.WECHAT.equals(complex)) {
            return new WeChatProvider(config, this.stateCache);
        }
        if (Registry.TAOBAO.equals(complex)) {
            return new TaobaoProvider(config, this.stateCache);
        }
        if (Registry.GOOGLE.equals(complex)) {
            return new GoogleProvider(config, this.stateCache);
        }
        if (Registry.FACEBOOK.equals(complex)) {
            return new FacebookProvider(config, this.stateCache);
        }
        if (Registry.DOUYIN.equals(complex)) {
            return new DouyinProvider(config, this.stateCache);
        }
        if (Registry.LINKEDIN.equals(complex)) {
            return new LinkedinProvider(config, this.stateCache);
        }
        if (Registry.MICROSOFT.equals(complex)) {
            return new MicrosoftProvider(config, this.stateCache);
        }
        if (Registry.MI.equals(complex)) {
            return new MiProvider(config, this.stateCache);
        }
        if (Registry.TOUTIAO.equals(complex)) {
            return new ToutiaoProvider(config, this.stateCache);
        }
        if (Registry.TEAMBITION.equals(complex)) {
            return new TeambitionProvider(config, this.stateCache);
        }
        if (Registry.RENREN.equals(complex)) {
            return new RenrenProvider(config, this.stateCache);
        }
        if (Registry.PINTEREST.equals(complex)) {
            return new PinterestProvider(config, this.stateCache);
        }
        if (Registry.STACK_OVERFLOW.equals(complex)) {
            return new StackOverflowProvider(config, this.stateCache);
        }
        if (Registry.HUAWEI.equals(complex)) {
            return new HuaweiProvider(config, this.stateCache);
        }
        if (Registry.WECHAT_ENTERPRISE.equals(complex)) {
            return new WeChatEEProvider(config, this.stateCache);
        }
        if (Registry.GITLAB.equals(complex)) {
            return new GitlabProvider(config, this.stateCache);
        }
        if (Registry.KUJIALE.equals(complex)) {
            return new KujialeProvider(config, this.stateCache);
        }
        throw new InstrumentException(Builder.Status.UNSUPPORTED.getCode());
    }

    public AuthProviderService(AuthProperties properties, StateCache stateCache) {
        this.properties = properties;
        this.stateCache = stateCache;
    }
}

