/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.storage.StorageProvider;

public abstract class AbstractProvider
implements StorageProvider {
    protected static final String DIR_SPLITER = "/";
    protected String accessKey;
    protected String secretKey;
    protected String bucket;
    protected String prefix;
    protected boolean privated;

    public static String downloadFile(String fileURL, String saveDir) {
        HttpURLConnection httpConn = null;
        FileOutputStream outputStream = null;
        try {
            URL url = new URL(fileURL);
            httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileURL.substring(fileURL.lastIndexOf(DIR_SPLITER) + 1, fileURL.length());
                }
                InputStream inputStream = httpConn.getInputStream();
                String saveFilePath = saveDir + File.separator + fileName;
                outputStream = new FileOutputStream(saveFilePath);
                int bytesRead = -1;
                byte[] buffer = new byte[2048];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                String string = saveFilePath;
                return string;
            }
            try {
                throw new InstrumentException("\u4e0b\u8f7d\u5931\u8d25");
            }
            catch (IOException e) {
                throw new InstrumentException("\u4e0b\u8f7d\u5931\u8d25", e);
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected String getFullPath(String file) {
        if (file.startsWith("http://") || file.startsWith("https://")) {
            return file;
        }
        return this.prefix + file;
    }

    @Override
    public String downloadAndSaveAs(String file, String localSaveDir, boolean isInternal) {
        return AbstractProvider.downloadFile(this.getUrl(file, isInternal), localSaveDir);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isPrivated() {
        return this.privated;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPrivated(boolean privated) {
        this.privated = privated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractProvider)) {
            return false;
        }
        AbstractProvider other = (AbstractProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        return this.isPrivated() == other.isPrivated();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractProvider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        result = result * 59 + (this.isPrivated() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AbstractProvider(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", bucket=" + this.getBucket() + ", prefix=" + this.getPrefix() + ", privated=" + this.isPrivated() + ")";
    }
}

