/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.getter.BasicTypeGetter;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.CollUtils;

public class Dict
extends LinkedHashMap<String, Object>
implements BasicTypeGetter<String> {
    private static final long serialVersionUID = 6135423866861206530L;

    public Dict() {
    }

    public Dict(int initialCapacity) {
        super(initialCapacity);
    }

    public Dict(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public Dict(Map<String, Object> m) {
        super(null == m ? new HashMap() : m);
    }

    public static Dict create() {
        return new Dict();
    }

    public static <T> Dict parse(T bean) {
        return Dict.create().parseBean(bean);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBeanIgnoreCase(T bean) {
        BeanUtils.fillBeanWithMapIgnoreCase(this, bean, false);
        return bean;
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanUtils.fillBeanWithMap(this, bean, isToCamelCase, false);
        return bean;
    }

    public <T> T toBeanWithCamelCase(T bean) {
        BeanUtils.fillBeanWithMap(this, bean, true, false);
        return bean;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtils.mapToBean(this, clazz, false);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanUtils.mapToBeanIgnoreCase(this, clazz, false);
    }

    public <T> Dict parseBean(T bean) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll(BeanUtils.beanToMap(bean));
        return this;
    }

    public <T> Dict parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll(BeanUtils.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dict> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = CollUtils.newHashSet(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || null == (value = this.get(entry.getKey())) || !value.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dict filter(String ... keys) {
        Dict result = new Dict(keys.length, 1.0f);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public Dict set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dict setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObj(String key) {
        return super.get(key);
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    @Override
    public String getStr(String attr) {
        return Convert.toString(this.get(attr), null);
    }

    @Override
    public Integer getInt(String attr) {
        return Convert.toInt(this.get(attr), null);
    }

    @Override
    public Long getLong(String attr) {
        return Convert.toLong(this.get(attr), null);
    }

    @Override
    public Float getFloat(String attr) {
        return Convert.toFloat(this.get(attr), null);
    }

    @Override
    public Short getShort(String attr) {
        return Convert.toShort(this.get(attr), null);
    }

    @Override
    public Character getChar(String attr) {
        return Convert.toChar(this.get(attr), null);
    }

    @Override
    public Double getDouble(String attr) {
        return Convert.toDouble(this.get(attr), null);
    }

    @Override
    public Byte getByte(String attr) {
        return Convert.toByte(this.get(attr), null);
    }

    @Override
    public Boolean getBool(String attr) {
        return Convert.toBool(this.get(attr), null);
    }

    @Override
    public BigDecimal getBigDecimal(String attr) {
        return Convert.toBigDecimal(this.get(attr));
    }

    @Override
    public BigInteger getBigInteger(String attr) {
        return Convert.toBigInteger(this.get(attr));
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return Convert.toEnum(clazz, this.get(key));
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Dict clone() {
        return (Dict)super.clone();
    }
}

