/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.metric;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.storage.metric.Cache;
import org.aoju.bus.storage.metric.CacheConfig;
import org.aoju.bus.storage.metric.CacheScheduler;

public class DefaultCache
implements Cache {
    private static Map<String, CacheState> stateCache = new ConcurrentHashMap<String, CacheState>();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.cacheLock.writeLock();
    private final Lock readLock = this.cacheLock.readLock();

    public DefaultCache() {
        if (CacheConfig.schedulePrune) {
            this.schedulePrune(CacheConfig.timeout);
        }
    }

    @Override
    public void set(String key, String value) {
        this.set(key, value, CacheConfig.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value, long timeout) {
        this.writeLock.lock();
        try {
            stateCache.put(key, new CacheState(value, timeout));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        this.readLock.lock();
        try {
            CacheState cacheState = stateCache.get(key);
            if (null == cacheState || cacheState.isExpired()) {
                String string = null;
                return string;
            }
            String string = cacheState.getState();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        this.readLock.lock();
        try {
            CacheState cacheState = stateCache.get(key);
            boolean bl = null != cacheState && !cacheState.isExpired();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void pruneCache() {
        Iterator<CacheState> values = stateCache.values().iterator();
        while (values.hasNext()) {
            CacheState cacheState = values.next();
            if (!cacheState.isExpired()) continue;
            values.remove();
        }
    }

    public void schedulePrune(long delay) {
        CacheScheduler.INSTANCE.schedule(this::pruneCache, delay);
    }

    private class CacheState
    implements Serializable {
        private String state;
        private long expire;

        CacheState(String state, long expire) {
            this.state = state;
            this.expire = System.currentTimeMillis() + expire;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expire;
        }

        public String getState() {
            return this.state;
        }

        public long getExpire() {
            return this.expire;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setExpire(long expire) {
            this.expire = expire;
        }
    }
}

