/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.UpYun;
import com.upyun.UpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class UpaiYunOssProvider
extends AbstractProvider {
    private UpYun client;

    public UpaiYunOssProvider(Context property) {
        this.property = property;
        Assert.notBlank(this.property.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.property.getEndpoint(), "[endpoint] not defined", new Object[0]);
        Assert.notBlank(this.property.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.property.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.property.getSecretKey(), "[secure] not defined", new Object[0]);
        this.client = new UpYun(this.property.getBucket(), this.property.getAccessKey(), this.property.getSecretKey());
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.property.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers download(String fileName, File file) {
        try {
            this.client.writeFile(fileName, file);
            return new Readers(null, "success");
        }
        catch (UpException | IOException e) {
            Logger.error("file download failed" + e.getMessage(), new Object[0]);
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers list() {
        try {
            List list = this.client.readDir(this.property.getPrefix());
            return new Readers(list.stream().map(item -> {
                Attachs storageItem = new Attachs();
                storageItem.setName(item.name);
                storageItem.setType(item.type);
                storageItem.setSize(StringUtils.toString(item.size));
                return storageItem;
            }).collect(Collectors.toList()));
        }
        catch (UpException | IOException e) {
            Logger.error("file list failed" + e.getMessage(), new Object[0]);
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.property.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers remove(String fileName) {
        try {
            this.client.deleteFile("/" + fileName);
            return new Readers("success");
        }
        catch (UpException | IOException e) {
            Logger.error("file remove failed", e.getMessage());
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

