/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.base.spring;

import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.base.spring.Controller;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.core.lang.exception.CrontabException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.exception.ValidateException;
import org.aoju.bus.core.utils.RuntimeUtils;
import org.aoju.bus.logger.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@RestControllerAdvice
public class BaseAdvice
extends Controller {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    @ModelAttribute
    public void addAttributes(Model model) {
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Object defaultException(Exception e) {
        Logger.error(RuntimeUtils.getStackTrace(e), new Object[0]);
        return BaseAdvice.write(ErrorCode.EM_FAILURE);
    }

    @ResponseBody
    @ExceptionHandler(value={InstrumentException.class})
    public Object instrumentException(InstrumentException e) {
        Logger.error(RuntimeUtils.getStackTrace(e), new Object[0]);
        return BaseAdvice.write(ErrorCode.EM_100510);
    }

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public Object businessException(BusinessException e) {
        Logger.error(RuntimeUtils.getStackTrace(e), new Object[0]);
        return BaseAdvice.write(ErrorCode.EM_100513);
    }

    @ResponseBody
    @ExceptionHandler(value={CrontabException.class})
    public Object crontabException(CrontabException e) {
        Logger.error(RuntimeUtils.getStackTrace(e), new Object[0]);
        return BaseAdvice.write(ErrorCode.EM_100514);
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Object validateException(ValidateException e) {
        Logger.error(RuntimeUtils.getStackTrace(e), new Object[0]);
        return BaseAdvice.write(e.getErrcode(), e.getErrmsg());
    }

    @ResponseBody
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Object httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        Logger.error(RuntimeUtils.getStackTrace((Throwable)e), new Object[0]);
        return BaseAdvice.write(ErrorCode.EM_100507);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Object httpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        Logger.error(RuntimeUtils.getStackTrace((Throwable)e), new Object[0]);
        return BaseAdvice.write(ErrorCode.EM_100508);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object noHandlerFoundException(NoHandlerFoundException e) {
        Logger.error(RuntimeUtils.getStackTrace((Throwable)e), new Object[0]);
        return BaseAdvice.write(ErrorCode.EM_100509);
    }
}

