/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ByteUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;

public class StreamUtils {
    private static final int COPY_BUFFER_SIZE = 2048;
    private static final int BUF_SIZE = 8192;
    private static final byte[] UTF_BOM = new byte[]{-17, -69, -65};

    public static boolean equals(InputStream ina, InputStream inb) throws IOException {
        int dA;
        while ((dA = ina.read()) != -1) {
            int dB = inb.read();
            if (dA == dB) continue;
            return false;
        }
        return inb.read() == -1;
    }

    public static void write(Writer writer, CharSequence cs) throws IOException {
        if (null != cs && null != writer) {
            writer.write(cs.toString());
            writer.flush();
        }
    }

    public static void writeAndClose(Writer writer, CharSequence cs) {
        try {
            StreamUtils.write(writer, cs);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(writer);
        }
    }

    public static long write(OutputStream ops, InputStream ins) throws IOException {
        return StreamUtils.write(ops, ins, 8192);
    }

    public static long write(OutputStream ops, InputStream ins, int bufferSize) throws IOException {
        int len;
        if (null == ops || null == ins) {
            return 0L;
        }
        byte[] buf = new byte[bufferSize];
        long bytesCount = 0L;
        while (-1 != (len = ins.read(buf))) {
            bytesCount += (long)len;
            ops.write(buf, 0, len);
        }
        if (0L == bytesCount) {
            ops.write(buf, 0, 0);
        }
        ops.flush();
        return bytesCount;
    }

    public static long writeAndClose(OutputStream ops, InputStream ins) {
        try {
            long l = StreamUtils.write(ops, ins);
            return l;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(ops);
            StreamUtils.safeClose(ins);
        }
    }

    public static long write(Writer writer, Reader reader) throws IOException {
        int len;
        if (null == writer || null == reader) {
            return 0L;
        }
        char[] cbuf = new char[8192];
        int count = 0;
        while ((len = reader.read(cbuf)) != -1) {
            writer.write(cbuf, 0, len);
            count += len;
        }
        return count;
    }

    public static long writeAndClose(Writer writer, Reader reader) {
        try {
            long l = StreamUtils.write(writer, reader);
            return l;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(writer);
            StreamUtils.safeClose(reader);
        }
    }

    public static void write(OutputStream ops, byte[] bytes) throws IOException {
        if (null == ops || null == bytes || bytes.length == 0) {
            return;
        }
        ops.write(bytes);
    }

    public static void writeAndClose(OutputStream ops, byte[] bytes) {
        try {
            StreamUtils.write(ops, bytes);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(ops);
        }
    }

    public static StringBuilder read(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        StreamUtils.read(reader, sb);
        return sb;
    }

    public static String readAndClose(Reader reader) {
        try {
            String string = StreamUtils.read(reader).toString();
            return string;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(reader);
        }
    }

    public static int read(Reader reader, StringBuilder sb) throws IOException {
        int len;
        char[] cbuf = new char[8192];
        int count = 0;
        while (-1 != (len = reader.read(cbuf))) {
            sb.append(cbuf, 0, len);
            count += len;
        }
        return count;
    }

    public static String readAll(Reader reader) {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        try {
            int len;
            StringBuilder sb = new StringBuilder();
            char[] data = new char[64];
            while ((len = reader.read(data)) != -1) {
                sb.append(data, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(reader);
        }
    }

    public static int readAndClose(InputStreamReader reader, StringBuilder sb) {
        try {
            int n = StreamUtils.read(reader, sb);
            return n;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(reader);
        }
    }

    public static byte[] readBytes(InputStream ins) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.write((OutputStream)out, ins);
        return out.toByteArray();
    }

    public static byte[] readBytesAndClose(InputStream ins) {
        byte[] bytes;
        try {
            bytes = StreamUtils.readBytes(ins);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(ins);
        }
        return bytes;
    }

    public static boolean safeClose(Closeable cb) {
        if (null != cb) {
            try {
                cb.close();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static void safeFlush(Flushable fa) {
        if (null != fa) {
            try {
                fa.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static BufferedInputStream buff(InputStream ins) {
        if (ins == null) {
            throw new NullPointerException("ins is null!");
        }
        if (ins instanceof BufferedInputStream) {
            return (BufferedInputStream)ins;
        }
        return new BufferedInputStream(ins);
    }

    public static BufferedOutputStream buff(OutputStream ops) {
        if (ops == null) {
            throw new NullPointerException("ops is null!");
        }
        if (ops instanceof BufferedOutputStream) {
            return (BufferedOutputStream)ops;
        }
        return new BufferedOutputStream(ops);
    }

    public static BufferedReader buffr(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static BufferedWriter buffw(Writer ops) {
        if (ops instanceof BufferedWriter) {
            return (BufferedWriter)ops;
        }
        return new BufferedWriter(ops);
    }

    public static InputStream findFileAsStream(String path, Class<?> klass, String enc) {
        File f = new File(path);
        if (f.exists()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e1) {
                return null;
            }
        }
        if (null != klass) {
            InputStream ins = klass.getClassLoader().getResourceAsStream(path);
            if (null == ins) {
                ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
            if (null != ins) {
                return ins;
            }
        }
        return ClassLoader.getSystemResourceAsStream(path);
    }

    public static InputStream utf8filte(InputStream in) {
        try {
            if (in.available() == -1) {
                return in;
            }
            PushbackInputStream pis = new PushbackInputStream(in, 3);
            byte[] header = new byte[3];
            int len = pis.read(header, 0, 3);
            if (len < 1) {
                return in;
            }
            if (header[0] != UTF_BOM[0] || header[1] != UTF_BOM[1] || header[2] != UTF_BOM[2]) {
                pis.unread(header, 0, len);
            }
            return pis;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static OutputStream fileOut(File file) {
        try {
            return StreamUtils.buff(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static Reader utf8r(InputStream is) {
        return new InputStreamReader(StreamUtils.utf8filte(is), Charset.UTF_8);
    }

    public static Writer utf8w(OutputStream os) {
        return new OutputStreamWriter(os, Charset.UTF_8);
    }

    public static InputStream wrap(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static void appendWriteAndClose(File f, String text) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(f, true);
            fw.write(text);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(fw);
                throw throwable;
            }
        }
        StreamUtils.safeClose(fw);
    }

    public static String nextLineTrim(BufferedReader br) throws IOException {
        String line = null;
        while (br.ready() && (line = br.readLine()) != null) {
            if (StringUtils.isBlank(line)) continue;
            return line.trim();
        }
        return line;
    }

    public static long writeAndClose(OutputStream ops, InputStream ins, int buf) {
        try {
            long l = StreamUtils.write(ops, ins, buf);
            return l;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            StreamUtils.safeClose(ops);
            StreamUtils.safeClose(ins);
        }
    }

    public static int readAvailable(InputStream in, byte[] b, int off, int len) throws IOException {
        int count;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int wpos = off;
        while (len > 0 && (count = in.read(b, wpos, len)) >= 0) {
            wpos += count;
            len -= count;
        }
        return wpos - off;
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (StreamUtils.readAvailable(in, b, off, len) < len) {
            throw new EOFException();
        }
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        while (n > 0L) {
            long count = in.skip(n);
            if (count == 0L) {
                if (in.read() == -1) {
                    throw new EOFException();
                }
                count = 1L;
            }
            n -= count;
        }
    }

    public static void copy(InputStream in, OutputStream out, byte[] buf) throws IOException {
        int count;
        while ((count = in.read(buf, 0, buf.length)) > 0) {
            if (out == null) continue;
            out.write(buf, 0, count);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamUtils.copy(in, out, new byte[2048]);
    }

    public static void copy(InputStream in, OutputStream out, int len, byte[] buf) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int count = in.read(buf, 0, Math.min(len, buf.length));
            if (count < 0) {
                throw new EOFException();
            }
            out.write(buf, 0, count);
            len -= count;
        }
    }

    public static void copy(InputStream in, OutputStream out, int len) throws IOException {
        StreamUtils.copy(in, out, len, new byte[Math.min(len, 2048)]);
    }

    public static void copy(InputStream in, OutputStream out, int len, int swapBytes, byte[] buf) throws IOException {
        if (swapBytes == 1) {
            StreamUtils.copy(in, out, len, buf);
            return;
        }
        if (swapBytes != 2 && swapBytes != 4) {
            throw new IllegalArgumentException("swapBytes: " + swapBytes);
        }
        if (len < 0 || len % swapBytes != 0) {
            throw new IllegalArgumentException("length: " + len);
        }
        int off = 0;
        while (len > 0) {
            int count = in.read(buf, off, Math.min(len, buf.length - off));
            if (count < 0) {
                throw new EOFException();
            }
            len -= count;
            off = (count += off) % swapBytes;
            count -= off;
            switch (swapBytes) {
                case 2: {
                    ByteUtils.swapShorts(buf, 0, count);
                    break;
                }
                case 4: {
                    ByteUtils.swapInts(buf, 0, count);
                    break;
                }
                case 8: {
                    ByteUtils.swapLongs(buf, 0, count);
                }
            }
            out.write(buf, 0, count);
            if (off <= 0) continue;
            System.arraycopy(buf, count, buf, 0, off);
        }
    }

    public static void copy(InputStream in, OutputStream out, int len, int swapBytes) throws IOException {
        StreamUtils.copy(in, out, len, swapBytes, new byte[Math.min(len, 2048)]);
    }

    public static InputStream openFileOrURL(String name) throws IOException {
        if (name.startsWith("resource:")) {
            URL url = ResourceUtils.getResource(name.substring(9), StreamUtils.class);
            if (url == null) {
                throw new FileNotFoundException(name);
            }
            return url.openStream();
        }
        if (name.indexOf(58) < 2) {
            return new FileInputStream(name);
        }
        return new URL(name).openStream();
    }
}

