/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.GetObjectRequest;
import com.baidubce.services.bos.model.ListObjectsRequest;
import com.baidubce.services.bos.model.ListObjectsResponse;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class BaiduYunBosProvider
extends AbstractProvider {
    private BosClient client;

    public BaiduYunBosProvider(Context property) {
        this.property = property;
        Assert.notBlank(this.property.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.property.getEndpoint(), "[endpoint] not defined", new Object[0]);
        Assert.notBlank(this.property.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.property.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.property.getSecretKey(), "[secure] not defined", new Object[0]);
        Assert.notNull(this.property.isSecure(), "[secure] not defined", new Object[0]);
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials((BceCredentials)new DefaultBceCredentials(this.property.getAccessKey(), this.property.getSecretKey()));
        config.setEndpoint(this.property.getEndpoint());
        this.client = new BosClient(config);
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.property.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.property.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucket, fileName), file);
        return new Readers("success");
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest(this.property.getBucket());
        ListObjectsResponse objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getContents().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getKey());
            storageItem.setOwner(item.getOwner().getDisplayName());
            storageItem.setSize(StringUtils.toString(item.getSize()));
            HashMap extended = Maps.newHashMap();
            extended.put("tag", item.getETag());
            extended.put("storageClass", item.getStorageClass());
            extended.put("lastModified", item.getLastModified());
            storageItem.setExtended(extended);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.property.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        this.client.putObject(bucket, fileName, content);
        return new Readers(null, "success");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        this.client.putObject(bucket, fileName, content);
        return new Readers(null, "success");
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.property.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers(null, "success");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

