/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.validate.Validated;
import org.aoju.bus.validate.validators.Property;

public class Collector {
    private Validated target;
    private List<Collector> result;
    private Property property;
    private boolean pass;

    public Collector(Validated target) {
        this.target = target;
        this.result = new ArrayList<Collector>();
    }

    public Collector(Collector collector) {
        this.target = collector.getTarget();
        this.result = new ArrayList<Collector>();
        this.result.add(collector);
    }

    public Collector(Validated target, Property property, boolean pass) {
        this.target = target;
        this.property = property;
        this.pass = pass;
    }

    public void collect(Collector collector) {
        this.result.add(collector);
    }

    public List<Collector> getResult() {
        ArrayList<Collector> list = new ArrayList<Collector>(16);
        for (Collector collector : this.result) {
            if (collector instanceof Collector) {
                list.addAll(collector.getResult());
                continue;
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6536\u96c6\u7684\u6821\u9a8c\u7ed3\u679c\u5bf9\u8c61\uff1a" + collector);
        }
        return list;
    }

    public Validated getTarget() {
        return this.target;
    }

    public boolean isPass() {
        return this.result.stream().allMatch(Collector::isPass);
    }

    public Property getProperty() {
        return this.property;
    }

    public void setTarget(Validated target) {
        this.target = target;
    }

    public void setResult(List<Collector> result) {
        this.result = result;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public void setPass(boolean pass) {
        this.pass = pass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Collector)) {
            return false;
        }
        Collector other = (Collector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Validated this$target = this.getTarget();
        Validated other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        List<Collector> this$result = this.getResult();
        List<Collector> other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        Property this$property = this.getProperty();
        Property other$property = other.getProperty();
        if (this$property == null ? other$property != null : !((Object)this$property).equals(other$property)) {
            return false;
        }
        return this.isPass() == other.isPass();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Collector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Validated $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        List<Collector> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        Property $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : ((Object)$property).hashCode());
        result = result * 59 + (this.isPass() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Collector(target=" + this.getTarget() + ", result=" + this.getResult() + ", property=" + this.getProperty() + ", pass=" + this.isPass() + ")";
    }
}

