/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.aoju.bus.cache.annotation.CacheKey;
import org.aoju.bus.cache.entity.CacheHolder;
import org.aoju.bus.cache.support.ArgNameGenerator;
import org.aoju.bus.cache.support.SpelCalculator;

public class KeyGenerator {
    public static String generateSingleKey(CacheHolder cacheHolder, Object[] argValues) {
        String[] argNames = ArgNameGenerator.getArgNames(cacheHolder.getMethod());
        Map<Integer, CacheKey> cacheKeyMap = cacheHolder.getCacheKeyMap();
        String prefix = cacheHolder.getPrefix();
        return KeyGenerator.doGenerateKey(cacheKeyMap, prefix, argNames, argValues);
    }

    public static Map[] generateMultiKey(CacheHolder cacheHolder, Object[] argValues) {
        LinkedHashMap multiEntry2Key = new LinkedHashMap();
        LinkedHashMap key2MultiEntry = new LinkedHashMap();
        Collection multiArgEntries = KeyGenerator.getMultiArgEntries(argValues[cacheHolder.getMultiIndex()]);
        Map<Integer, CacheKey> argIndex2CacheKey = cacheHolder.getCacheKeyMap();
        String prefix = cacheHolder.getPrefix();
        Object[] argNames = ArgNameGenerator.getArgNames(cacheHolder.getMethod());
        String[] appendArgNames = (String[])KeyGenerator.appendArray(argNames, "i");
        int i = 0;
        for (Object multiElement : multiArgEntries) {
            Object[] appendArgValues = KeyGenerator.appendArray(argValues, i);
            String key = KeyGenerator.doGenerateKey(argIndex2CacheKey, prefix, appendArgNames, appendArgValues);
            key2MultiEntry.put(key, multiElement);
            multiEntry2Key.put(multiElement, key);
            ++i;
        }
        return new Map[]{multiEntry2Key, key2MultiEntry};
    }

    private static String doGenerateKey(Map<Integer, CacheKey> parameterIndex2CacheKey, String prefix, String[] argNames, Object[] argValues) {
        StringBuilder sb = new StringBuilder(prefix);
        for (Map.Entry<Integer, CacheKey> entry : parameterIndex2CacheKey.entrySet()) {
            int argIndex = entry.getKey();
            String argSpel = entry.getValue().value();
            Object defaultValue = KeyGenerator.getDefaultValue(argValues, argIndex);
            Object keyPart = SpelCalculator.calcSpelValueWithContext(argSpel, argNames, argValues, defaultValue);
            sb.append(keyPart);
        }
        return sb.toString();
    }

    private static Object getDefaultValue(Object[] argValues, int argIndex) {
        return argValues[argIndex];
    }

    private static Collection getMultiArgEntries(Object multiArg) {
        if (multiArg == null) {
            return Collections.emptyList();
        }
        if (multiArg instanceof Collection) {
            return (Collection)multiArg;
        }
        if (multiArg instanceof Map) {
            return ((Map)multiArg).keySet();
        }
        return Arrays.stream((Object[])multiArg).collect(Collectors.toList());
    }

    private static Object[] appendArray(Object[] origin, Object append) {
        Object[] dest = Arrays.copyOf(origin, origin.length + 1);
        dest[origin.length] = append;
        return dest;
    }
}

